/*
 * @(#)AdminConnect.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin ;

import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.admin.info.ConnectInfo;
import org.maachang.queue.access.admin.info.CreateConnectInfo;


/**
 * コネクション管理情報.
 * <BR><BR>
 * コネクション管理情報を表すインターフェイス.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public interface AdminConnect {
    
    /**
     * コネクション情報を追加.
     * <BR><BR>
     * 新しいコネクション情報を生成します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param info コネクション情報生成条件を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void addConnect( CreateConnectInfo info )
        throws MaachangQException ;
    
    /**
     * コネクション情報を再設定.
     * <BR><BR>
     * 新しいコネクション情報を再設定します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param info コネクション情報生成条件を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void setConnect( ConnectInfo info )
        throws MaachangQException ;
    
    /**
     * コネクションを削除.
     * <BR><BR>
     * コネクションを削除します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param name 削除対象のコネクション名を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void removeConnect( String name )
        throws MaachangQException ;
    
    /**
     * コネクション情報を取得.
     * <BR><BR>
     * コネクション情報を取得します.
     * <BR>
     * @param name 対象のコネクション名を設定します.
     * @return ConnectInfo 対象のコネクション情報が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public ConnectInfo getConnect( String name )
        throws MaachangQException ;
    
    /**
     * コネクション名一覧を取得.
     * <BR><BR>
     * コネクション名一覧を取得します.
     * <BR>
     * @return String[] コネクション名一覧が返されます.
     */
    public String[] getNames() ;
    
    /**
     * コネクション情報サイズを取得.
     * <BR><BR>
     * コネクション情報サイズを取得します.
     * <BR>
     * @return int コネクション情報数が返されます.
     */
    public int size() ;
    
    /**
     * コネクション名が存在するかチェック.
     * <BR><BR>
     * コネクション名が存在するかチェックします.
     * <BR>
     * @param name チェック対象のコネクション名を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、存在します.<BR>
     *                 [false]が返された場合、存在しません.
     * @exception MaachangQException MaachangQ例外.
     */
    public boolean isConnect( String name )
        throws MaachangQException ;
    
    /**
     * 管理コネクションオブジェクトを取得.
     * <BR><BR>
     * 管理コネクションオブジェクトを取得します.
     * <BR>
     * @return MaachangQConnectAdmin 管理コネクションオブジェクトが返されます.
     */
    public MaachangQConnectAdmin getMaachangQConnectAdmin() ;
    
}

