/*
 * @(#)AdminCacheBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol.admin ;

/**
 * 管理者用キャッシュBean.
 *  
 * @version 2007/01/07
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class AdminCacheBean extends BaseAdminProtocolBean {
    
    /**
     * 最大数.
     */
    private int maxSize = -1 ;
    
    /**
     * 現在利用数.
     */
    private int useSize = -1 ;
    
    /**
     * コンストラクタ.
     */
    public AdminCacheBean() {
        
    }
    
    /**
     * 利用率を取得.
     * <BR><BR>
     * 現在の利用率を取得します.
     * <BR>
     * @return int 利用率が返されます.
     */
    public int getUsePersent() {
        if( maxSize < 0 || useSize < 0 ) {
            return -1 ;
        }
        return ( int )(
            ( ( double )useSize / ( double )maxSize ) * 100.0f
        ) ;
    }

    /**
     * maxSize を取得.
     * <BR><BR>
     * @return maxSize が返されます.
     */
    public int getMaxSize() {
        return maxSize;
    }

    /**
     * maxSize を設定.
     * <BR><BR>
     * @param maxSize maxSize を設定します.
     */
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    /**
     * useSize を取得.
     * <BR><BR>
     * @return useSize が返されます.
     */
    public int getUseSize() {
        return useSize;
    }

    /**
     * useSize を設定.
     * <BR><BR>
     * @param useSize useSize を設定します.
     */
    public void setUseSize(int useSize) {
        this.useSize = useSize;
    }
    
    
    
}
