#!/bin/sh
################################################################################
# build.sh.
#
# Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved.
################################################################################
ARGS=${1}

if [ ${ARGS:--1} = "-1" ];
then
    ARGS=all
fi

################################################################################
# Please set up environment.
################################################################################

# java home.
SET_JAVA_HOME=

# maachang-q home
SET_MAACHANGQ=

################################################################################
# check.
################################################################################

if [ ${SET_JAVA_HOME:--1} = "-1" ];
then
    export JAVA_HOME=SET_JAVA_HOME
fi
if [ ${SET_MAACHANGQ:--1} = "-1" ];
then
    export MAACHANGQ=SET_MAACHANGQ
fi

if [ ${JAVA_HOME:--1} = "-1" ];
then
    echo "not environment JAVA_HOME."
    exit 1
fi
if [ ${MAACHANGQ:--1} = "-1" ];
then
    echo "not environment MAACHANG."
    exit 1
fi

################################################################################
# build.
################################################################################

MAACHANG_COMMONS=MaachangCommons
MAACHANG_CONNECT=MaachangConnect
MAACHANG_ACCESS=MaachangQAccess
MAACHANG_Q=MaachangQ
MAACHANG_CLIENT=MaachangQClient

cd ${MAACHANGQ}

echo *******************************************************************************
echo ** ${MAACHANG_COMMONS} [${ARGS}] s ** .
echo *******************************************************************************

cd ${MAACHANG_COMMONS}
if [ ${ARGS} = "all" ];
then
ant clean
ant compile
ant jar
ant javadoc
fi
if [ ${ARGS} != "all" ];
then
ant ${ARGS}
fi

cd ../

echo *******************************************************************************
echo ** ${MAACHANG_CONNECT} [${ARGS}] ** .
echo *******************************************************************************

cd ${MAACHANG_CONNECT}
if [ ${ARGS} = "all" ];
then
ant clean
ant compile
ant jar
ant javadoc
fi
if [ ${ARGS} != "all" ];
then
ant ${ARGS}
fi

cd ../

echo *******************************************************************************
echo ** ${MAACHANG_ACCESS} [${ARGS}] ** .
echo *******************************************************************************

cd ${MAACHANG_ACCESS}
if [ ${ARGS} = "all" ];
then
ant clean
ant compile
ant jar
ant javadoc
fi
if [ ${ARGS} != "all" ];
then
ant ${ARGS}
fi

cd ../

echo *******************************************************************************
echo ** ${MAACHANG_Q} [${ARGS}] ** .
echo *******************************************************************************

cd ${MAACHANG_Q}
if [ ${ARGS} = "all" ];
then
ant clean
ant compile
ant jar
ant javadoc
fi
if [ ${ARGS} != "all" ];
then
ant ${ARGS}
fi

cd ../

echo *******************************************************************************
echo ** ${MAACHANG_CLIENT} [${ARGS}] ** .
echo *******************************************************************************

cd ${MAACHANG_CLIENT}
if [ ${ARGS} = "all" ];
then
ant clean
ant compile
ant jar
ant javadoc
fi
if [ ${ARGS} != "all" ];
then
ant ${ARGS}
fi

if [ ${ARGS} = "all" ];
then
cd build
cd lib
copy *.jar ../jar
fi

exit 0
