/*
 * @(#)AsynchronousException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.BaseException;

/**
 * 他のスレッドにより、コネクションがクローズされた場合の
 * 例外.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class AsynchronousException extends CommunicateException
{
    /**
     * コンタストラクタ.
     */
    public AsynchronousException()
    {
        super( CommunicateException.ASYNCHRONOUSE_CLOSE ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public AsynchronousException(Throwable e)
    {
        super( e,CommunicateException.ASYNCHRONOUSE_CLOSE ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public AsynchronousException(BaseException e)
    {
        super( e,CommunicateException.ASYNCHRONOUSE_CLOSE ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public AsynchronousException(String message)
    {
        super( CommunicateException.ASYNCHRONOUSE_CLOSE,message ) ;
        
    }
}
