/*
 * @(#)NotConnectException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.BaseException;

/**
 * 未接続例外.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NotConnectException extends CommunicateException
{
    /**
     * コンタストラクタ.
     */
    public NotConnectException()
    {
        super( CommunicateException.NO_CONNECT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotConnectException(Throwable e)
    {
        super( e,CommunicateException.NO_CONNECT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotConnectException(BaseException e)
    {
        super( e,CommunicateException.NO_CONNECT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NotConnectException(String message)
    {
        super( CommunicateException.NO_CONNECT,message ) ;
        
    }
}
