/*
 * @(#)FTPPause.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net.ftp;

/**
 * FTP要素.
 * <BR><BR>
 * FTPクライアントの１要素です.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
class FTPPause
{
    
    /**
     * ファイル/ディレクトリモード.
     */
    private boolean m_mode = false ;
    
    /**
     * 権限.
     */
    private int m_owner = 0 ;
    
    /**
     * ファイルサイズ.
     */
    private long m_size = 0L ;
    
    /**
     * 格納日付.
     */
    private long m_date = 0L ;
    
    
    
    /**
     * コンストラクタ.
     */
    private FTPPause()
    {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 情報を生成します.
     * <BR>
     * @param mode ファイル/ディレクトリモードを設定します.<BR>
     *             [true]を設定した場合ディレクトリです.<BR>
     *             [false]を設定した場合ファイルです.
     * @param oder 権限を設定します.
     * @param size ファイルサイズを設定します.
     * @param date 日付を設定します.
     */
    public FTPPause( boolean mode,int oder,long size,long date )
    {
        m_mode = mode ;
        m_owner = oder ;
        m_date = date ;
        
        if( m_mode == true ){
            m_size = -1L ;
        }
        else{
            m_size = size ;
        }
    }
    
    /**
     * ファイル/ディレクトリモードを取得.
     * <BR><BR>
     * ファイル/ディレクトリモードを取得します.
     * <BR>
     * @return boolean ファイル/ディレクトリモードが返されます.<BR>
     *                 [true]が返された場合ディレクトリです.<BR>
     *                 [false]が返された場合ファイルです.
     */
    public final boolean getMode()
    {
        return m_mode ;
    }
    
    /**
     * 権限を取得.
     * <BR><BR>
     * 権限を取得します.
     * <BR>
     * @return int 権限が返されます.
     */
    public final int getOwner()
    {
        return m_owner ;
    }
    
    /**
     * ファイルサイズを取得.
     * <BR><BR>
     * ファイルサイズを取得します.
     * <BR>
     * @return long ファイルサイズが返されます.
     */
    public final long getSize()
    {
        return m_size ;
    }
    
    /**
     * 日付情報を取得.
     * <BR><BR>
     * 日付情報を取得します.
     * <BR>
     * @return long 日付情報が返されます.<BR>
     *              またこの情報は年は含まれていません.
     */
    public final long getDate()
    {
        return m_date ;
    }
    
}
