/*
 * @(#)BinResource.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.resource ;

/**
 * バイナリリソースインターフェイス.
 * <BR><BR>
 * バイナリリソース情報を扱うインターフェイスを提供します.
 *
 * @version     1.00, 2005/04/01
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public interface BinResource
{
    
    /**
     * バイナリリソースタイプ : メモリー.
     */
    public static final int BIN_RESOURCE_TYPE_MEMORY = ResourceType.RESOURCE_TYPE_MEMORY ;
    
    /**
     * バイナリリソースタイプ : ファイル.
     */
    public static final int BIN_RESOURCE_TYPE_FILE = ResourceType.RESOURCE_TYPE_FILE ;
    
    /**
     * バイナリリソースタイプ : キャッシュファイル.
     */
    public static final int BIN_RESOURCE_TYPE_CACHE = ResourceType.RESOURCE_TYPE_CACHE ;
    
    
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() ;
    
    /**
     * リセット処理.
     * <BR><BR>
     * 有効データ長をリセットします.
     */
    public void reset() ;
    
    /**
     * 情報設定.
     * <BR><BR>
     * 対象条件に情報を設定します.
     * <BR>
     * @param no 設定対象項番を設定します.
     * @param b 設定対象のバイト情報を設定します.
     */
    public void set( int no,int b ) ;
    
    /**
     * バイナリ情報設定.
     * <BR><BR>
     * 対象のバイナリ情報を設定します.
     * <BR>
     * @param no 設定開始位置となる項番を設定します.
     * @param bin 設定対象のバイナリ情報を設定します.
     * @return int 設定されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int setBinary( int no,byte[] bin ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報設定.
     * <BR><BR>
     * 対象のバイナリ情報を設定します.
     * <BR>
     * @param no 設定開始位置となる項番を設定します.
     * @param bin 設定対象のバイナリ情報を設定します.
     * @param off 設定対象のオフセット値を設定します.
     * @param len 設定対象のバイナリ長を設定します.
     * @return int 設定されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int setBinary( int no,byte[] bin,int off,int len ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報設定.
     * <BR><BR>
     * 対象のバイナリ情報を設定します.
     * <BR>
     * @param no 設定開始位置となる項番を設定します.
     * @param bin 設定対象のバイナリオブジェクトを設定します.
     * @return int 設定されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int setBinary( int no,BinResource bin ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報設定.
     * <BR><BR>
     * 対象のバイナリ情報を設定します.
     * <BR>
     * @param no 設定開始位置となる項番を設定します.
     * @param bin 設定対象のバイナリオブジェクトを設定します.
     * @param off 設定対象のオフセット値を設定します.
     * @param len 設定対象のバイナリ長を設定します.
     * @return int 設定されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int setBinary( int no,BinResource bin,int off,int len ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * 情報取得.
     * <BR><BR>
     * 対象条件の情報を取得します.
     * <BR>
     * @param no 取得対象項番を設定します.
     * @return int 対象のバイナリ情報が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int get( int no ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 格納されているバイナリ情報を取得します.
     * <BR>
     * @return byte[] 設定されているバイナリ情報が返されます.
     */
    public byte[] getBinary() ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 対象のバイナリ情報を取得します.
     * <BR>
     * @param no 取得開始位置となる項番を設定します.
     * @return byte[] 取得されたバイナリ情報が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public byte[] getBinary( int no ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 対象のバイナリ情報を取得します.
     * <BR>
     * @param no 取得開始位置となる項番を設定します.
     * @param len 取得対象のバイナリ長を設定します.
     * @return byte[] 取得されたバイナリ情報が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public byte[] getBinary( int no,int len ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 格納されているバイナリ情報を取得します.
     * <BR>
     * @param out 取得対象のバイナリ情報が返されます.
     * @return int 取得されたバイナリ長が返されます.
     */
    public int getBinary( byte[] out ) ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 対象のバイナリ情報を取得します.
     * <BR>
     * @param out 取得対象のバイナリ情報が返されます.
     * @param no 取得開始位置となる項番を設定します.
     * @return int 取得されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int getBinary( byte[] out,int no ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 対象のバイナリ情報を取得します.
     * <BR>
     * @param out 取得対象のバイナリ情報が返されます.
     * @param no 取得開始位置となる項番を設定します.
     * @param off 取得対象のバイナリオフセット値を設定します.
     * @param len 取得対象のバイナリ長を設定します.
     * @return int 取得されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int getBinary( byte[] out,int no,int off,int len ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 格納されているバイナリ情報を取得します.
     * <BR>
     * @param out 取得対象のバイナリ情報が返されます.
     * @return int 取得されたバイナリ長が返されます.
     */
    public int getBinary( BinResource out ) ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 対象のバイナリ情報を取得します.
     * <BR>
     * @param out 取得対象のバイナリ情報が返されます.
     * @param no 取得開始位置となる項番を設定します.
     * @return int 取得されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int getBinary( BinResource out,int no ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 対象のバイナリ情報を取得します.
     * <BR>
     * @param out 取得対象のバイナリ情報が返されます.
     * @param no 取得開始位置となる項番を設定します.
     * @param off 取得対象のバイナリオフセット値を設定します.
     * @param len 取得対象のバイナリ長を設定します.
     * @return int 取得されたバイナリ長が返されます.
     * @exception ArrayIndexOutOfBoundsException 不正インデックス例外.
     */
    public int getBinary( BinResource out,int no,int off,int len ) throws ArrayIndexOutOfBoundsException ;
    
    /**
     * 現在の有効バイナリ長を取得.
     * <BR><BR>
     * 現在の有効なバイナリ長を取得します.
     * <BR>
     * @return int 現在の有効なバイナリ長が返されます.
     */
    public int size() ;
    
    /**
     * 現在のバイナリ長を取得.
     * <BR><BR>
     * 現在のバイナリ長を取得します.
     * <BR>
     * @return int 現在のバイナリ長が返されます.
     */
    public int getAllSize() ;
    
    /**
     * オブジェクトタイプを取得.
     * <BR><BR>
     * オブジェクトタイプを取得します.
     * <BR>
     * @return int オブジェクトタイプが返されます.<BR>
     *             [BinResource#BIN_RESOURCE_TYPE_MEMORY]が返された場合、
     *             [org.maachang.commons.resource.BinMemoryResource]オブジェクトです.<BR>
     *             [BinResource#BIN_RESOURCE_TYPE_FILE]が返された場合、
     *             [org.maachang.commons.resource.BinFileResource]オブジェクトです.<BR>
     *             [BinResource#BIN_RESOURCE_TYPE_CACHE]が返された場合、
     *             [org.maachang.commons.resource.BinCacheResource]オブジェクトです.
     */
    public int getType() ;
    
    /**
     * オブジェクト有効チェック.
     * <BR><BR>
     * オブジェクトが有効であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合有効です.<BR>
     *                 [false]が返された場合無効です.
     */
    public boolean isUse() ;
    
    
}
