/*
 * @(#)CoreCharTable.java
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util;

import java.io.Serializable;
import java.util.HashMap;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.serialize.SerializeUtil;


/**
 * CoreCharTableオブジェクト.
 * <BR><BR>
 * String情報をkeyとして管理するオブジェクトです.
 * また、このオブジェクトは内部オブジェクトです.
 *
 * @version 1.00, 2003/11/01
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
class CoreCharTable implements Serializable
{
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            CoreCharTable.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * データ格納テーブル.
     */
    private final HashMap m_table = new HashMap() ;
    
    
    /**
     * コンストラクタ.
     */
    protected CoreCharTable()
    {
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     */
    protected final void clear()
    {
        m_table.clear() ;
    }
    
    /**
     * 情報の追加.
     */
    protected final void add( String name,Object value )
        throws InputException
    {
        if( name == null || value == null ){
            throw new InputException( "引数が不正です" ) ;
        }
        
        m_table.put( name,value ) ;
    }
    
    /**
     * 指定情報の削除.
     */
    protected final Object remove( String name )
        throws InputException
    {
        Object ret = null ;
        
        if( name == null ){
            throw new InputException( "引数が不正です" ) ;
        }
        ret = m_table.remove( name ) ;
        
        return ret ;
    }
    
    /**
     * 情報取得.
     */
    protected final Object get( String name )
    {
        Object ret = null ;
        
        if( name == null ){
            return null ;
        }
        
        ret = m_table.get( name ) ;
        
        return ret ;
    }
    
    /**
     * 情報存在チェック.
     */
    protected final boolean isData( String name )
    {
        boolean ret ;
        
        if( name == null ){
            return false ;
        }
        
        ret = ( m_table.get( name ) == null ) ? false : true ;
        
        return ret ;
    }

    
    /**
     * 格納情報数の取得.
     */
    protected final int size()
    {
        return m_table.size() ;
    }
    
    /**
     * 格納文字列配列の取得.
     */
    protected final String[] getNames()
    {
        int i ;
        int len ;
        
        String[] ret = null ;
        Object[] obj = null ;
        
        obj = m_table.keySet().toArray() ;
        if( obj != null ){
            len = obj.length ;
            
            if( len <= 0 ){
                obj = null ;
                return null ;
            }
            
            ret = new String[ len ] ;
            for( i = 0 ; i < len ; i ++ ){
                ret[ i ] = ( String )obj[ i ] ;
                obj[ i ] = null ;
            }
            obj = null ;
        }
        
        return ret ;
    }
    
}
