/*
 * @(#)KeyDLong.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util;

/**
 * 2つのLongKey.
 *
 * @version     1.00, 2006/05/06
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class KeyDLong implements Comparable
{
    /**
     * Key1.
     */
    private long key1 = -1L ;
    
    /**
     * Key2.
     */
    private long key2 = -1L ;
    
    /**
     * コンストラクタ.
     */
    public KeyDLong(){
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を設定して生成します.
     */
    public KeyDLong( long key1,long key2 )
    {
        this.key1 = key1 ;
        this.key2 = key2 ;
    }
    
    /**
     * 比較処理.
     * <BR><BR>
     * 指定オブジェクトの内容と比較します.
     * <BR>
     * @param o チェック対象のオブジェクト.
     * @return int チェック結果が返されます.
     */
    public int compareTo( Object o )
    {
        long tmp ;
        KeyDLong k = null ;
        
        if( o == null || ( o instanceof KeyDLong ) == false ){
            if( o == null ){
                return -1 ;
            }
            throw new ClassCastException( "オブジェクトの型が違います" ) ;
        }
        
        k = ( KeyDLong )o ;
        
        if( k.key1 == key1 ){
            tmp = key2 - k.key2 ;
        }
        else{
            tmp = key1 - k.key1 ;
        }
        
        if( tmp == 0 ){
            return 0 ;
        }
        else if( tmp < 0 ){
            return -1 ;
        }
        
        return 1 ;
    }
    
    /**
     * @return
     */
    public long getKey1() {
        return key1;
    }

    /**
     * @return
     */
    public long getKey2() {
        return key2;
    }

    /**
     * @param l
     */
    public void setKey1(long l) {
        key1 = l;
    }

    /**
     * @param l
     */
    public void setKey2(long l) {
        key2 = l;
    }

}

