/*
 * @(#)SearchPortion.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util;

import java.util.ArrayList;

/**
 * 配列部分検索.
 * <BR><BR>
 * 配列内を部分検索して取得する処理を提供します.
 *
 * @version 1.00, 2005/02/27
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class SearchPortion
{
    
    /**
     * ワイルドカード条件 : なし.
     */
    public static final int NOT_WCD = 0 ;
    
    /**
     * ワイルドカード条件 : 検索条件なし.
     */
    public static final int NOT_SEARCH = -1 ;
    
    
    /**
     * 検索ワイルドカード.
     */
    private static final String WCD = "*?" ;
    
    
    
    /**
     * 文字列配列検索処理.
     * <BR><BR>
     * 対象の文字列配列から、指定条件で検索します.
     * <BR>
     * @param value 検索対象の文字列を設定します.
     * @param searchCode 部分検索を行う条件を設定します.
     * @return String[] 検索結果が返されます.<BR>
     *                  [null]が返された場合、検索条件に対する結果が存在しません.
     */
    public static final String[] searchString( String[] value,String searchCode )
    {
        int i,j ;
        int len ;
        int lenJ ;
        int ifPnt ;
        int pnt ;
        int retLen ;
        boolean flg ;
        boolean mode ;
        boolean wmode ;
        
        ArrayList index = null ;
        String sd = null ;
        String[] tmp = null ;
        String[] ret = null ;
        
        if(
            value == null || value.length <= 0 ||
            searchCode == null || searchCode.length() <= 0
        )
        {
            return null ;
        }
        
        try{
            
            // ワイルドカードインデックスを取得.
            index = UtilCom.pauseString( searchCode,WCD ) ;
            
            if( index != null && ( lenJ = index.size() ) > 0 ){
                
                // 一番初めにワイルドカードが存在するかチェック.
                len = WCD.length() ;
                for( i = 0,mode = false,wmode = false ; i < len ; i ++ ){
                    ifPnt = searchCode.indexOf( WCD.charAt( i ) ) ;
                    if( ifPnt == -1 ){
                        continue ;
                    }
                    else if( ifPnt == 0 ){
                        mode = true ;
                        wmode = true ;
                        break ;
                    }
                    else{
                        wmode = true ;
                        break ;
                    }
                }
                
                len = value.length ;
                
                // ワイルドカードが全く存在なしの場合.
                if( lenJ == 1 && wmode == false ){
                    
                    tmp = new String[ len ] ;
                    retLen = 0 ;
                    for( i = 0 ; i < len ; i ++ ){
                        if( value[ i ].indexOf( searchCode ) == 0 ){
                            tmp[ retLen ] = value[ i ] ;
                            retLen ++ ;
                        }
                    }
                    
                }
                // ワイルドカードが存在する場合.
                else{
                    
                    tmp = new String[ len ] ;
                    retLen = 0 ;
                    
                    for( i = 0 ; i < len ; i ++ ){
                        
                        for( j = 0,pnt = 0,flg = true ; j < lenJ ; j ++ ){
                            
                            sd = ( String )index.get( j ) ;
                            
                            ifPnt = value[ i ].indexOf( sd,pnt ) ;
                            
                            // ワイルドカードが先頭に存在しない場合.
                            if( mode == false ){
                                if(
                                    ( j == 0 && ifPnt == 0 ) ||
                                    ( j != 0 && ifPnt != -1 )
                                )
                                {
                                    pnt = ifPnt+sd.length() ;
                                }
                                else{
                                    flg = false ;
                                    break ;
                                }
                            }
                            // ワイルドカードが先頭に存在する場合.
                            else{
                                if( ifPnt != -1 ){
                                    pnt = ifPnt+sd.length() ;
                                }
                                else{
                                    flg = false ;
                                    break ;
                                }
                            }
                            
                        }
                        
                        if( flg == true ){
                            tmp[ retLen ] = value[ i ] ;
                            retLen ++ ;
                        }
                        
                    }
                    
                }
                
                // 検索結果が存在する場合.
                if( retLen > 0 ){
                    ret = new String[ retLen ] ;
                    System.arraycopy( tmp,0,ret,0,retLen ) ;
                }
                
            }
            // 条件が存在しない場合.
            else{
                // そのまま返す.
                ret = value ;
            }
            
        }catch( Exception e ){
            ret = null ;
        }finally{
            if( index != null ){
                index.clear() ;
            }
            index = null ;
            sd = null ;
            tmp = null ;
        }
        
        return ret ;
    }
    
    
    /**
     * 指定検索文字にワイルドカードが設定されているかチェック.
     * <BR><BR>
     * 指定検索文字にワイルドカードが設定されているかチェックします.
     * <BR>
     * @param searchCode チェック対象の検索文字を設定します.
     * @return int チェック結果が返されます.<BR>
     *             [SearchPortion.NOT_WCD]が返された場合、ワイルドカードは存在しません.<BR>
     *             [SearchPortion.NOT_SEARCH]が返された場合、対象検索条件は存在しません.<BR>
     *             0以上の値が返された場合、その数のワイルドカードが存在します.
     */
    public static final int isWildCard( String searchCode )
    {
        int i,j ;
        int len ;
        int lenJ ;
        char tmp ;
        int noWd ;
        boolean flg ;
        int ret ;
        
        char[] wd = null ;
        
        try{
            
            ret = NOT_WCD ;
            len = searchCode.length() ;
            lenJ = WCD.length() ;
            wd = new char[ lenJ ] ;
            WCD.getChars( 0,lenJ,wd,0 ) ;
            
            for( i = 0,noWd = 0 ; i < len ; i ++ ){
                
                tmp = searchCode.charAt( i ) ;
                
                for( j = 0,flg = false ; j < lenJ ; j ++ ){
                    if( tmp == wd[ j ] ){
                        flg = true ;
                        ret ++ ;
                        break ;
                    }
                }
                
                noWd = ( flg == false ) ? noWd + 1 : noWd ;
                
            }
            
            ret = ( noWd == 0 ) ? NOT_SEARCH : ret ;
            
        }catch( Exception e ){
            ret = NOT_SEARCH ;
        }finally{
            wd = null ;
        }
        
        return ret ;
    }
    
}
