/*
 * @(#)MaachangQShutdownHook.java
 *
 * Copyright (c) 2004 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * MaachangQシャットダウンフック.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-1.00
 */
class MaachangQShutdownHook extends Thread {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( MaachangQShutdownHook.class ) ;
    
    /**
     * MaachangQStartup.
     */
    private MaachangQStartup startup = null ;
    
    /**
     * コンストラクタ.
     */
    private MaachangQShutdownHook() {
        
    }
    
    /**
     * コンストラクタ.
     */
    public MaachangQShutdownHook( MaachangQStartup startup ) {
        
        this.startup = startup ;
        this.setPriority( Thread.MAX_PRIORITY ) ;
        this.setDaemon( false ) ;
        
    }
    
    /**
     * シャットダウンフック.
     */
    public final void run() {
        
        LOG.info (
            "## [MaachangQ]シャットダウンフックを開始します"
        ) ;
        
        // シャットダウン処理を実施.
        try{
            this.startup.destroy() ;
        }catch( Exception e ){
        }
        
        LOG.info (
            "## [MaachangQ]シャットダウンフックを終了します"
        ) ;
        
    }
    
}

