/*
 * @(#)AbstractExecutionAdmin.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.connect.admin ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.queue.access.MaachangQAccessDefine;
import org.maachang.queue.access.MaachangQErrorCode;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.net.ConnectObject;
import org.maachang.queue.access.protocol.CommonProtocol;
import org.maachang.queue.access.protocol.ResultProtocol;
import org.maachang.queue.access.protocol.admin.BaseAdminProtocolBean;
import org.maachang.queue.connect.ExecutionAdmin;
import org.maachang.queue.connect.admin.login.LoginManager;
import org.maachang.queue.connect.admin.login.LoginSession;
import org.maachang.queue.connect.common.ServerConnectThread;
import org.maachang.queue.connect.common.Telegram;


/**
 * 管理者系通信処理.
 *
 * @version 2007/01/17
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
abstract class AbstractExecutionAdmin implements ExecutionAdmin {
    
    /**
     * ログオブジェクト.
     */
    protected static final Log LOG = LogFactory.getLog(
        AbstractExecutionAdmin.class ) ;
    
    /**
     * 管理者実行処理IDを取得.
     * <BR><BR>
     * 設定されている管理者実行処理IDを取得します.
     * <BR>
     * @return int 管理者実行処理IDが返されます.
     */
    public abstract int getId() ;
    
    /**
     * 実行処理.
     * <BR><BR>
     * 各管理者用実行処理を実装するためのメソッド.
     * <BR>
     * @param telegramType 処理対象の実行タイプを格納します.
     * @param connect コネクションオブジェクトが設定されます.
     * @param session 対象のログインセッションが設定されます.
     * @param id 対象の電文IDが設定されます.
     * @param telegram 受信された電文が設定されます.
     * @return boolean 処理結果が返されます.
     * @exception Exception 例外.
     */
    public abstract boolean execution( int[] telegramType,LoginSession session,
        ConnectObject connect,int id,Telegram telegram )
        throws Exception ;
    
    /**
     * ユーザログイン状態を確認.
     * <BR><BR>
     * ユーザログイン状態を確認します.
     * <BR>
     * @param session 対象のセッション情報を設定します.
     * @param bean 対象のBean情報を設定します.
     * @exception Exception 例外.
     */
    protected void checkLogin( LoginSession session,BaseAdminProtocolBean bean )
        throws Exception {
        this.checkLogin( false,session,bean ) ;
    }
    
    /**
     * ユーザログイン状態を確認.
     * <BR><BR>
     * ユーザログイン状態を確認します.
     * <BR>
     * @param 権限チェックを行うモード.<BR>
     *        [true]が設定された場合、チェックします.
     * @param session 対象のセッション情報を設定します.
     * @param bean 対象のBean情報を設定します.
     * @exception Exception 例外.
     */
    protected void checkLogin( boolean mode,LoginSession session,
        BaseAdminProtocolBean bean )
        throws Exception {
        
        if( session.getId() != bean.getUserId() ) {
            throw new MaachangQException(
                "ログインしていません",
                MaachangQErrorCode.ERROR_NOT_USER ) ;
        }
        
        if( mode == true &&
            ( bean.getType() | CommonProtocol.MASK_ROOT_OWNER ) ==
                CommonProtocol.MASK_ROOT_OWNER ) {
            mode = true ;
        }
        else {
            mode = false ;
        }
        
        LoginManager.checkLoginUser( mode,session ) ;
    }
    
    /**
     * メッセージの送信.
     */
    protected void sendResult( ConnectObject connect,BaseAdminProtocolBean bean,
        int errorCode,String message ) {
        
        int errType ;
        if( errorCode == MaachangQErrorCode.SUCCESS ) {
            errType = ResultProtocol.TYPE_SUCCESS ;
        }
        else {
            errType = ResultProtocol.TYPE_ERROR ;
        }
        
        ServerConnectThread.sendRsult(
            bean.getId(),errType,bean.getType(),CommonProtocol.DUMMY,
            CommonProtocol.DUMMY,MaachangQAccessDefine.TYPE_SEND,connect,
            message,errorCode ) ;
    }
}

