/*
 * @(#)ExecutionAdminResultLogin.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.connect.admin ;

import org.maachang.queue.access.MaachangQErrorCode;
import org.maachang.queue.access.net.ConnectObject;
import org.maachang.queue.access.protocol.ResultProtocol;
import org.maachang.queue.access.protocol.login.LoginBean;
import org.maachang.queue.access.protocol.login.LoginProtocol;
import org.maachang.queue.connect.ExecutionAdmin;
import org.maachang.queue.connect.admin.login.LoginManager;
import org.maachang.queue.connect.admin.login.LoginSession;
import org.maachang.queue.connect.common.ServerConnectThread;
import org.maachang.queue.connect.common.Telegram;


/**
 * ログイン戻り系電文処理.
 *
 * @version 2007/01/15
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class ExecutionAdminResultLogin implements ExecutionAdmin {
    
    /**
     * コンストラクタ.
     */
    public ExecutionAdminResultLogin() {
        
    }
    
    /**
     * 管理者実行処理IDを取得.
     * <BR><BR>
     * 設定されている管理者実行処理IDを取得します.
     * <BR>
     * @return int 管理者実行処理IDが返されます.
     */
    public int getId() {
        return LoginProtocol.CATEGORY_TYPE_RESULT_LOGIN ;
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * 各管理者用実行処理を実装するためのメソッド.
     * <BR>
     * @param telegramType 処理対象の実行タイプを格納します.
     * @param connect コネクションオブジェクトが設定されます.
     * @param session 対象のログインセッションが設定されます.
     * @param id 対象の電文IDが設定されます.
     * @param telegram 受信された電文が設定されます.
     * @return boolean 処理結果が返されます.
     * @exception Exception 例外.
     */
    public boolean execution( int[] telegramType,LoginSession session,
        ConnectObject connect,int id,Telegram telegram )
        throws Exception {
        
        byte[] binary = telegram.getTelegram() ;
        telegram.clear() ;
        
        // 受信バイナリを解析.
        LoginBean bean = new LoginBean() ;
        LoginProtocol.analysisResultProtocol( bean,binary ) ;
        telegramType[ 0 ] = bean.getType() ;
        binary = null ;
        
        // ログアウト処理.
        LoginManager.logout( session ) ;
        
        // 正常戻り値を設定.
        ServerConnectThread.sendRsult( id,ResultProtocol.TYPE_SUCCESS,
            bean.getType(),connect,"ログアウト成功",MaachangQErrorCode.SUCCESS ) ;
        
        return true ;
    }
    
}

