/*
 * @(#)ProtocolResultSuccess.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.protocol ;

/**
 * チャネル通信正常プロトコル.
 * 
 * @version 2006/08/31
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ProtocolResultSuccess implements ProtocolObject {
    
    /**
     * 電文ID.
     */
    private long id = -1L ;
    
    /**
     * 処理名.
     */
    private String name = null ;
    
    /**
     * キューマネージャ名.
     */
    private String queueManagerName = null ;
    
    /**
     * チャネル名.
     */
    private String channelName = null ;
    
    /**
     * プロトコル戻りタイプ.
     */
    private int returnType = -1 ;
    
    /**
     * 受信ポート番号.
     */
    private int port = -1 ;
    
    /**
     * チャネルID.
     */
    private int channelId = -1 ;
    
    /**
     * コンストラクタ.
     */
    public ProtocolResultSuccess() {
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        
        id = -1L ;
        name = null ;
        queueManagerName = null ;
        channelName = null ;
        returnType = -1 ;
        port = -1 ;
        channelId = -1 ;
        
    }
    
    /**
     * 電文ID情報を取得.
     * <BR><BR>
     * 電文ID情報を取得します.
     * <BR>
     * @return long 電文ID情報が返されます.
     */
    public long getId() {
        return id;
    }
    
    /**
     * 電文ID情報を設定.
     * <BR><BR>
     * 電文ID情報を設定します.
     * <BR>
     * @param id 対象の電文IDを設定します.
     */
    public void setId(long id) {
        this.id = id;
    }
    
    /**
     * 処理名を取得.
     * <BR><BR>
     * 処理名を取得します.
     * <BR>
     * @return String 処理名が返されます.
     */
    public String getName() {
        return name ;
    }
    
    /**
     * 処理名を設定.
     * <BR><BR>
     * 処理名を設定します.
     * <BR>
     * @param name キュー名を設定します.
     */
    public void setName(String name) {
        this.name = name ;
    }
    
    /**
     * キューマネージャ名を取得.
     * <BR><BR>
     * キューマネージャ名を取得します.
     * <BR>
     * @return String キューマネージャ名が返されます.
     */
    public String getQueueManagerName() {
        return queueManagerName ;
    }
    
    /**
     * キューマネージャ名を設定.
     * <BR><BR>
     * キューマネージャ名を設定します.
     * <BR>
     * @param queueManagerName キューマネージャ名を設定します.
     */
    public void setQueueManagerName( String queueManagerName ) {
        this.queueManagerName = queueManagerName ;
    }
    
    /**
     * チャネル名を設定.
     * <BR><BR>
     * チャネル名を設定します.
     * <BR>
     * @param channelName 対象のチャネル名を設定します.
     */
    public void setChannelName( String channelName ) {
        this.channelName = channelName ;
    }
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * チャネル名を取得します.
     * <BR>
     * @return String チャネル名が返されます.
     */
    public String getChannelName() {
       return this.channelName ;
    }
    
    /**
     * 受信ポート番号を取得.
     * <BR><BR>
     * 受信ポート番号を取得します.
     * <BR>
     * @return int 受信ポート番号が返されます.
     */
    public int getReceivePort() {
        return port ;
    }
    
    /**
     * 受信ポート番号を設定.
     * <BR><BR>
     * 受信ポート番号を設定します.
     * <BR>
     * @param port 受信ポート番号を設定します.
     */
    public void setReceivePort( int port ) {
        this.port = port ;
    }
    
    /**
     * チャネルIDを取得
     * <BR><BR>
     * チャネルIDを取得します.
     * <BR>
     * @return int チャネルIDが返されます.
     */
    public int getChannelId() {
        return channelId ;
    }
    
    /**
     * チャネルIDを設定.
     * <BR><RB>
     * チャネルIDを設定します.
     * <BR>
     * @param channelId 対象のチャネルIDを設定します.
     */
    public void setChannelId( int channelId ) {
        this.channelId = channelId ;
    }
    
    /**
     * プロトコルタイプを取得.
     * <BR><BR>
     * プロトコルタイプを取得します.
     * <BR>
     * @return int プロトコルタイプが返されます.<BR>
     *             [ProtocolObject.PROTOCOL_DATA]が返された場合、データオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_HEARTBEAT]が返された場合、ハートビートオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_SUCCESS]が返された場合、正常オブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_ERROR]が返された場合ｍエラーオブジェクトです.
     */
    public int getType() {
        return ProtocolObject.PROTOCOL_SUCCESS ;
    }
    
    /**
     * プロトコル戻りタイプを設定.
     * <BR><BR>
     * プロトコル戻りタイプを設定します.
     * <BR>
     * @param type プロトコル戻りタイプを設定します.
     */
    public void setReturnType( int type ) {
        returnType = type ;
    }
    
    /**
     * プロトコル戻りタイプを取得.
     * <BR><BR>
     * プロトコル戻りタイプを取得します.
     * <BR>
     * @return int プロトコル戻りタイプが返されます.
     */
    public int getReturnType() {
        return returnType ;
    }
    
    /**
     * オブジェクトを文字列に変換.
     * <BR><BR>
     * オブジェクトを文字列に変換します.
     * <BR>
     * @return String 文字列に変換された情報が返されます.
     */
    public String toString() {
        
        String ret = null ;
        
        ret = new StringBuffer().
            append( "[PROTOCOL_SUCCESS]" ).
            append( " id:" ).
            append( id ).
            append( " name:" ).
            append( name ).
            append( " queueManagerName:" ).
            append( queueManagerName ).
            append( " channelName:" ).
            append( channelName ).
            append( " returnType:" ).
            append( returnType ).
            append( " port:" ).
            append( port ).
            append( " channelId:" ).
            append( channelId ).
            toString() ;
            
        return ret ;
    }
    
}

