/*
 * @(#)ChannelService.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.queue.config.MqConfig;
import org.maachang.queue.config.service.ConfigService;
import org.maachang.queue.main.channel.service.receive.ReceiveService;
import org.maachang.queue.main.channel.service.send.SendService;



/**
 * チャネルサービス.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ChannelService {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( ChannelService.class ) ;
    
    /**
     * コンストラクタ.
     */
    public ChannelService() { }
    
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を行います.
     * <BR>
     * @exception Exception 例外.
     */
    public void init()
        throws Exception {
        
        LOG.info( "#### MaachangQチャネルサービス生成処理 ####" ) ;
        
        this.destroy( false ) ;
        
        MqConfig conf = ConfigService.getMqConfig() ;
        
        ReceiveService receive = new ReceiveService() ;
        receive.init(
            conf.getCoreThread(),
            conf.getSwitchThread(),
            conf.getDataAnalysisThread(),
            conf.getHeartBeatAnalysisThread(),
            conf.getErrorAnalysisThread(),
            conf.getSuccessAnalysisThread() ) ;
        
        SendService send = new SendService() ;
        send.init(
            conf.getSendThread(),
            conf.getHearbeatTiming(),
            conf.getHeartBeatCloseCount() ) ;
        
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     */
    public void destroy() {
        this.destroy( true ) ;
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     * <BR>
     * @param mode ログ表示モードを設定します.
     */
    public void destroy( boolean mode ) {
        
        if( mode == true ) {
            LOG.info( "#### MaachangQチャネルサービス破棄処理 ####" ) ;
        }
        
        new ReceiveService().destroy( mode ) ;
        new SendService().destroy( mode ) ;
    }
    
}
