/*
 * @(#)PoolProtocol.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service.receive ;

import org.maachang.queue.main.channel.protocol.ProtocolObject;
import org.maachang.queue.main.channel.protocol.ProtocolResultError;
import org.maachang.queue.main.channel.protocol.ProtocolResultSuccess;

/**
 * 受信プロトコルプーリング.
 *
 * @version 2006/12/23
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
class PoolProtocol {
    
    /**
     * 受信主プロトコルオブジェクト.
     */
    private ProtocolObject baseProtocol = null ;
    
    /**
     * 戻り正常プロトコル.
     */
    private ProtocolResultSuccess protocolResultSuccess = null ;
    
    /**
     * 戻り異常プロトコル.
     */
    private ProtocolResultError protocolResultError = null ;
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param protocol 受信主プロトコルオブジェクトを設定します.
     */
    public PoolProtocol( ProtocolObject protocol ) {
        this.baseProtocol = protocol ;
        this.protocolResultSuccess = new ProtocolResultSuccess() ;
        this.protocolResultError = new ProtocolResultError() ;
    }
    
    /**
     * 終了化処理.
     */
    protected void finalize()
        throws Exception {
        this.baseProtocol = null ;
        this.protocolResultSuccess = null ;
        this.protocolResultError = null ;
    }

    /**
     * baseProtocolを取得.
     * <BR><BR>
     * @return baseProtocol が返されます。
     */
    public ProtocolObject getBaseProtocol() {
        return baseProtocol;
    }

    /**
     * protocolResultErrorを取得.
     * <BR><BR>
     * @return protocolResultError が返されます。
     */
    public ProtocolResultError getProtocolResultError() {
        return protocolResultError;
    }

    /**
     * protocolResultSuccessを取得.
     * <BR><BR>
     * @return protocolResultSuccess が返されます。
     */
    public ProtocolResultSuccess getProtocolResultSuccess() {
        return protocolResultSuccess;
    }
}

