/*
 * @(#)QueueManager.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.manager ;

import org.maachang.commons.exception.InputException;
import org.maachang.queue.main.queue.Queue;
import org.maachang.queue.main.queue.QueueBean;
import org.maachang.queue.main.queue.QueueKey;

/**
 * 拡張キューマネージャインターフェイス.
 * <BR><BR>
 * １つの拡張キューマネージャを表すインターフェイスです.
 * 
 * @version 2006/09/03
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface BaseQueueManager extends QueueManager {
    
    /**
     * 新しいQueueBeanオブジェクトを生成.
     * <BR><BR>
     * 新しいQueueBeanオブジェクトを生成します.
     * <BR>
     * @param queueType 対象のキュータイプを設定します.
     * @param queueName 対象のキュー名を設定します.
     * @return AdminQueueBean QueueBeanオブジェクトが返されます.
     * @exception InputException 入力例外.
     */
    public QueueBean createQueueBean( int queueType,String queueName )
        throws InputException ;
    
    /**
     * キュー情報を追加.
     * <BR><BR>
     * キュー情報を、このマネージャに追加します.
     * <BR>
     * @param queue 追加対象のキューオブジェクトを設定します.
     * @exception InputException 入力例外.
     */
    public void addQueue( Queue queue )
        throws InputException ;
    
    /**
     * キュー情報を削除.
     * <BR><BR>
     * キュー情報を、このマネージャから削除します.
     * <BR>
     * @param key 削除対象のKey要素情報を設定します.
     */
    public void removeQueue( QueueKey key ) ;
    
    /**
     * キュー情報を削除.
     * <BR><BR>
     * キュー情報を、このマネージャから削除します.
     * <BR>
     * @param queueType 削除対象のキュータイプを設定します.
     * @param name 削除対象のキュー名を設定します.
     */
    public void removeQueue( int queueType,String name ) ;
    
    /**
     * キュー情報を削除.
     * <BR><BR>
     * キュー情報を、このマネージャから削除します.
     * <BR>
     * @param mode 削除時にキュー情報も削除するか設定します.<BR>
     *             [true]を設定した場合、キュー情報も削除します.<BR>
     *             [false]を設定した場合、キュー情報は削除しません.
     * @param key 削除対象のKey要素情報を設定します.
     */
    public void removeQueue( boolean mode,QueueKey key ) ;
    
    /**
     * キュー情報を削除.
     * <BR><BR>
     * キュー情報を、このマネージャから削除します.
     * <BR>
     * @param mode 削除時にキュー情報も削除するか設定します.<BR>
     *             [true]を設定した場合、キュー情報も削除します.<BR>
     *             [false]を設定した場合、キュー情報は削除しません.
     * @param queueType 削除対象のキュータイプを設定します.
     * @param name 削除対象のキュー名を設定します.
     */
    public void removeQueue( boolean mode,int queueType,String name ) ;
    
    /**
     * キュー情報を取得.
     * <BR><BR>
     * キュー情報を、このマネージャから取得します.
     * <BR>
     * @param key 対象のKey要素情報を設定します.
     */
    public Queue getQueue( QueueKey key ) ;
    
    /**
     * キュー情報を取得.
     * <BR><BR>
     * キュー情報を、このマネージャから取得します.
     * <BR>
     * @param queueType 対象のキュータイプを設定します.
     * @param name 対象のキュー名を設定します.
     */
    public Queue getQueue( int queueType,String name ) ;
    
    /**
     * キュー数を取得.
     * <BR><BR>
     * このマネージャで管理しているキュー数を取得.
     * <BR>
     * @param queueType 対象のキュータイプを設定します.
     * @return int キュー数が返されます.
     */
    public int getQueueSize( int queueType ) ;
    
    /**
     * Key要素情報一覧を取得.
     * <BR><BR>
     * このマネージャで管理しているKey要素情報一覧を取得.
     * <BR>
     * @param queueType 対象のキュータイプを設定します.
     * @return QueueKey[] Key要素一覧が返されます.
     */
    public QueueKey[] getKeyElements( int queueType ) ;
    
}

