/*
 * @(#)QueueManager.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.manager ;

import org.maachang.commons.resource.ResourceType;
import org.maachang.queue.main.cache.MqCache;
import org.maachang.queue.main.queue.QueueKey;

/**
 * キューマネージャインターフェイス.
 * <BR><BR>
 * １つのキューマネージャを表すインターフェイスです.
 * 
 * @version 2006/09/03
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface QueueManager {
    
    /**
     * キューマネージャ名を取得.
     * <BR><BR>
     * キューマネージャ名を取得します.
     * <BR>
     * @return String キューマネージャ名が返されます.
     */
    public String getName() ;
    
    /**
     * キューマネージャステータスを取得.
     * <BR><BR>
     * 対象のキューマネージャステータスを取得します.
     * <BR>
     * @return int 対象のキューマネージャステータス情報が返されます.<BR>
     *             [STATE_SUCCESS]が返された場合、「正常」です.<BR>
     *             [STATE_DOWN]が返された場合、「停止」です.<BR>
     *             [STATE_STARTUP]が返された場合、「起動中」です.<BR>
     *             [STATE_SHUTDOWN]が返された場合、「停止」です.<BR>
     *             [STATE_ERROR]が返された場合、「異常」です.<BR>
     *             [STATE_PLANNED_STOP]が返された場合、「計画停止」です.
     */
    public int getState() ;
    
    /**
     * キャッシュ名を取得.
     * <BR><BR>
     * キャッシュ名を取得します.
     * <BR>
     * @return String キャッシュ名が返されます.<BR>
     *                [null]が返された場合、キャッシュは利用しません.
     */
    public String getCacheName() ;
    
    /**
     * リソースタイプを取得.
     * <BR><BR>
     * キューマネージャのリソースタイプが返されます.
     * <BR>
     * @return ResourceType リソースタイプが返されます.<BR>
     *                      [null]が返された場合、キャッシュは利用しません.
     */
    public ResourceType getResourceType() ;
    
    /**
     * キャッシュオブジェクトを取得.
     * <BR><BR>
     * このキューマネージャに割り当てられているキャッシュ情報を取得します.
     * <BR>
     * @return MqCache キャッシュオブジェクトが返されます.<BR>
     *                 [null]が返された場合、キャッシュは利用しません.
     */
    public MqCache getMqCache() ;
    
    /**
     * キューマネージャステータスを取得.
     * <BR><BR>
     * 対象のキューマネージャステータスを取得します.
     * <BR>
     * @param state 対象のキューマネージャステータス情報を設定します.
     */
    public void setState( int state ) ;
    
    /**
     * キュー数を取得.
     * <BR><BR>
     * このマネージャで管理しているキュー数を取得.
     * <BR>
     * @return int キュー数が返されます.
     */
    public int getQueueSize() ;
    
    /**
     * Key要素情報一覧を取得.
     * <BR><BR>
     * このマネージャで管理しているKey要素情報一覧を取得.
     * <BR>
     * @return QueueKey[] Key要素一覧が返されます.
     */
    public QueueKey[] getKeyElements() ;
    
    /**
     * QueueManagerBeanを取得.
     * <BR><BR>
     * このマネージャのQueueManagerBean情報を取得します.
     * <BR>
     * @return AdminQueueManagerBean QueueManagerBean情報が返されます.
     */
    public QueueManagerBean getQueueManagerBean() ;
    
    /**
     * キューマネージャオブジェクトが有効であるか取得.
     * <BR><BR>
     * キューマネージャオブジェクトが有効であるか取得します.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、有効です.<BR>
     *                 [false]が返された場合、無効です.
     */
    public boolean isQueueManager() ;
}

