/*
 * @(#)QueueManagerStateNotSuccessException.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.manager;

import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.queue.access.MaachangQErrorCode;
import org.maachang.queue.access.MaachangQException;

/**
 * キューマネージャステータスが正常ではない.
 *  
 * @version 2006/12/21
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class QueueManagerStateNotSuccessException extends MaachangQException
{
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            QueueManagerStateNotSuccessException.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public QueueManagerStateNotSuccessException(Throwable e)
    {
        super(e) ;
        super.errorCode = MaachangQErrorCode.ERROR_QUEUE_MANAGER_NOT_SUCCESS ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public QueueManagerStateNotSuccessException(String message)
    {
        super(message) ;
        super.errorCode = MaachangQErrorCode.ERROR_QUEUE_MANAGER_NOT_SUCCESS ;
    }
}
