/*
 * @(#)AbstractSendMq.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import org.maachang.queue.access.MaachangQException;

/**
 * 送信MQを表すオブジェクト.
 * <BR><BR>
 * 1つの送信MQを表すオブジェクトです.
 *  
 * @version 2006/12/21
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
abstract class AbstractSendMq extends AbstractMq implements SendMqInterface {
    
    /**
     * メッセージ情報を設定.
     * <BR><BR>
     * 対象のメッセージ情報を設定します.
     * <BR>
     * @param transactionId 対象のトランザクションIDを設定します.
     * @param key 対象のキー条件を設定します.<BR>
     *            [null]や[""]を設定した場合、キー条件を無視します.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象のメッセージ情報を設定します.
     * @param priority 対象の優先順位を設定します.
     * @param expire 対象の電文寿命を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void put( int transactionId,String key,String processId,
        byte[] value,int priority,int expire )
        throws MaachangQException {
        
        this.checkTransaction( transactionId ) ;
        this.checkState() ;
        
        try {
            super.queue.put( transactionId,key,processId,
                value,priority,expire ) ;
        } catch( MessageOverException mo ) {
            throw new SendDataMessageOver(
                "キューに対する送信メッセージ長は上限を超しています" ) ;
        } catch( QueueFullException ful ) {
            throw new SendDataFull(
                "対象キューはキューフル状態です" ) ;
        }
    }
    
    /**
     * put処理ができるかチェック.
     * <BR><BR>
     * put処理ができるかチェックします.
     * <BR>
     * @param transactionId 対象のトランザクションIDを設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    private void checkTransaction( int transactionId )
        throws MaachangQException {
        if( super.isAutoCommit() == false ) {
            
            if( super.getTransactionId() == Queue.TRANSACTION_BY_ALREADY_EXISTENCE ) {
                throw new NotTransactionException(
                    "トランザクションは開始されていません" ) ;
            }
            else if( super.getTransactionId() != transactionId ) {
                throw new AlreadyExistenceException(
                    "他のコネクションがトランザクションを保持しています" ) ;
            }
        }
    }
}

