/*
 * @(#)ConnectMq.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

/**
 * キューコネクション.
 * <BR><BR>
 * 接続中のキューを表すインターフェイス.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface ConnectMq {
    
    /**
     * コネクションを解放.
     * <BR><BR>
     * コネクションを解放します.
     */
    public void disconnect() ;
    
    /**
     * トランザクション開始.
     * <BR><BR>
     * トランザクションを開始します.
     * <BR>
     * @exception MaachangQException MaachangQ例外.
     */
    public void transaction() throws MaachangQException ;
    
    /**
     * コミット処理.
     * <BR><BR>
     * コミット処理を行います.
     * <BR>
     * @exception MaachangQException MaachangQ例外.
     */
    public void commit() throws MaachangQException ;
    
    /**
     * ロールバック処理.
     * <BR><BR>
     * ロールバック処理を行います.
     * <BR>
     * @exception MaachangQException MaachangQ例外.
     */
    public void rollback() throws MaachangQException ;
    
    /**
     * 対象キュータイプを取得.
     * <BR><BR>
     * 対象のキュータイプを取得します.
     * <BR>
     * @return int キュータイプが返されます.<BR>
     *             [MaachangQAccessDefine.TYPE_SEND]が返された場合、送信キューです.<BR>
     *             [MaachangQAccessDefine.TYPE_RECEIVE]が返された場合、受信キューです.
     */
    public int getQueueType() ;
    
    /**
     * 対象キュー名を取得.
     * <BR><BR>
     * 接続中の対象キュー名を取得します.
     * <BR>
     * @return String 対象キュー名が返されます.
     */
    public String getName() ;
    
    /**
     * 対象キューマネージャ名を取得.
     * <BR><BR>
     * 接続中のキューマネージャ名を取得します.
     * <BR>
     * @return String 対象キューマネージャ名が返されます.
     */
    public String getManagerName() ;
    
    /**
     * MaachangQManagerオブジェクトを取得.
     * <BR><BR>
     * MaachangQManagerオブジェクトを取得します.
     * <BR>
     * @return MaachangQManager 対象のマネージャオブジェクトが返されます.
     */
    public MaachangQManager getMaachangQManager() ;
    
    /**
     * オートコミットモード取得.
     * <BR><BR>
     * このキューがオートコミットモードであるか取得します.
     * <BR>
     * @return boolean オートコミットモードを取得します.<BR>
     *                 [true]が返された場合、オートコミットです.<BR>
     *                 [false]が返された場合、オートコミットではありません.
     */
    public boolean isAutoCommit() ;
    
    /**
     * トランザクション中であるかチェック.
     * <BR><BR>
     * トランザクション中であるかチェックします.
     * <BR>
     * @return boolean トランザクション中であるかチェックします.<BR>
     *                 [true]が返された場合、トランザクション中です.<BR>
     *                 [false]が返された場合、トランザクション中ではありません.
     */
    public boolean isTransaction() ;
    
    /**
     * キューマネージャがオープン中かチェック.
     * <BR><RB>
     * 対象のキューマネージャがオープン中であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、オープン中です.<BR>
     *                 [false]が返された場合、クローズしています.
     */
    public boolean isOpen() ;
    
}

