/*
 * @(#)ConnectReceiveMq.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

/**
 * 受信キューコネクション.
 * <BR><BR>
 * 接続中の受信キューを表すインターフェイス.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public interface ConnectReceiveMq extends ConnectSendMq {
    
    /**
     * 受信処理.
     * <BR><BR>
     * データ受信処理を行います.
     * <BR>
     * @param value 受信された情報が格納されます.<BR>
     *              また、検索キー情報を設定する場合は、この情報に設定してください.
     * @param timeout 受信タイムアウト値を設定します.<BR>
     *                [0]以下を設定した場合、無限にタイムアウトを待ちます.
     * @exception MaachangQException MaachangQ例外.
     */
    public void receive( MqValue value,int timeout )
        throws MaachangQException ;
    
}

