/*
 * @(#)LoginTelegram.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin ;

import org.maachang.queue.access.protocol.CommonProtocol;
import org.maachang.queue.access.protocol.login.LoginBean;
import org.maachang.queue.access.protocol.login.LoginProtocol;


/**
 * ログイン用電文.
 *  
 * @version 2007/01/11
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
class LoginTelegram {
    
    /**
     * ログイン電文作成処理.
     * <BR><BR>
     * ログイン電文を作成します.
     * <BR>
     * @param out 対象の電文IDが格納されます.
     * @param user 対象のユーザ名を設定します.
     * @param passwd 対象のパスワードを設定します.
     * @param shutdown シャットダウンモードを設定します.<BR>
     *                 [true]を設定した場合、接続先のMaachangQはシャットダウンします.
     * @return byte[] 対象の電文情報が返されます.
     * @exception Exception 例外.
     */
    public static final byte[] createLoginTelegram( int[] out,String user,String passwd,boolean shutdown )
        throws Exception {
        
        if( out != null && out.length > 0 ) {
            out[ 0 ] = CommonProtocol.getSequenceId() ;
            return LoginProtocol.createProtocol(
                out[ 0 ],       // 電文ID.
                user,           // ユーザ名.
                passwd,         // パスワード.
                shutdown        // シャットダウンコマンド.
                ) ;
        }
        
        throw new IllegalArgumentException( "out引数は不正です" ) ;
        
    }
    
    /**
     * ログアウト電文作成.
     * <BR><BR>
     * ログアウト電文を作成します.
     * <BR>
     * @param out 対象の電文IDが格納されます.
     * @param userId ログアウト対象のユーザIDを設定します.
     * @param userOwner 対象のユーザオーナを設定します.
     * @return byte[] 対象の電文情報が返されます.
     * @exception Exception 例外.
     */
    public static final byte[] createLogoutTelegram( int[] out,int userId,boolean userOwner )
        throws Exception {
        
        if( out != null && out.length > 0 ) {
            out[ 0 ] = CommonProtocol.getSequenceId() ;
            return LoginProtocol.createResultProtocol(
                out[ 0 ],       // 電文ID.
                userId,         // ユーザID.
                userOwner       // ユーザオーナ.
                ) ;
        }
        
        throw new IllegalArgumentException( "out引数は不正です" ) ;
        
    }
    
    /**
     * ログイン結果を解析.
     * <BR><BR>
     * ログイン結果を解析します.
     * <BR>
     * @param out データ受け取り用Beanを設定します.
     * @param telegram 対象の電文を設定します.
     * @exception Exception 例外.
     */
    public static final void analysisTelegram( LoginBean out,byte[] telegram )
        throws Exception {
        
        if( out == null || telegram == null || telegram.length <= 0 ) {
            throw new IllegalArgumentException( "out引数は不正です" ) ;
        }
        
        int[] outId = new int[ 1 ] ;
        byte[] bin = CommonProtocol.analysisProtocol( null,outId,telegram ) ;
        LoginProtocol.analysisResultProtocol( out,bin ) ;
        
        out.setTelegramId( outId[ 0 ] ) ;
        
    }
}

