/*
 * @(#)MaachangQConnectAdmin.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin ;

import java.net.InetAddress;

import org.maachang.queue.access.MaachangQException;


/**
 * MaachangQ管理者接続情報.
 * <BR><BR>
 * MaachangQ管理者接続情報を表すインターフェイス.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public interface MaachangQConnectAdmin {
    
    /**
     * コネクションをクローズ.
     * <BR><BR>
     * コネクションをクローズします.
     */
    public void close() ;
    
    /**
     * 再度ログイン.
     * <BR><BR>
     * 再度ログイン処理を行います.
     * <BR>
     * @param user 対象のログインユーザ名を設定します.
     * @param passwd 対象のログインパスワードを設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void login( String user,String passwd )
        throws MaachangQException ;
    
    /**
     * MaachangQシャットダウン.
     * <BR><BR>
     * 接続先のMaachangQをシャットダウンします.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @exception MaachangQException MaachangQ例外.
     */
    public void shutdown() throws MaachangQException ;
    
    /**
     * ユーザ管理オブジェクトを取得.
     * <BR><BR>
     * ユーザ管理オブジェクトを取得します.
     * <BR>
     * @return AdminUser ユーザ管理オブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public AdminUser getAdminUser()
        throws MaachangQException ;
    
    /**
     * キューマネージャ管理オブジェクトを取得.
     * <BR><BR>
     * キューマネージャ管理オブジェクトを取得します.
     * <BR>
     * @return AdminQueueManager キューマネージャ管理オブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public AdminQueueManager getAdminQueueManager()
        throws MaachangQException ;
    
    /**
     * キュー管理オブジェクトを取得.
     * <BR><BR>
     * キュー管理オブジェクトを取得します.
     * <BR>
     * @param manager 対象のキューマネージャ名を設定します.
     * @return AdminQueue キュー管理オブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public AdminQueue getAdminQueue( String manager )
        throws MaachangQException ;
    
    /**
     * チャネル管理オブジェクトを取得.
     * <BR><BR>
     * チャネル管理オブジェクトを取得します.
     * <BR>
     * @return AdminQueueManager チャネル管理オブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public AdminChannel getAdminChannel()
        throws MaachangQException ;
    
    /**
     * コネクション管理オブジェクトを取得.
     * <BR><BR>
     * コネクション管理オブジェクトを取得します.
     * <BR>
     * @return AdminConnect コネクション管理オブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public AdminConnect getAdminConnect()
        throws MaachangQException ;
    
    /**
     * キャッシュ管理オブジェクトを取得.
     * <BR><BR>
     * キャッシュ管理オブジェクトを取得します.
     * <BR>
     * @return AdminCache キャッシュ管理オブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public AdminCache getAdminCache()
        throws MaachangQException ;
    
    /**
     * 現在接続中のユーザ名を取得.
     * <BR><BR>
     * 現在接続中のユーザ名を取得します.
     * <BR>
     * @return String 現在接続中のユーザ名が返されます.
     */
    public String getUserName() ;
    
    /**
     * 接続先アドレスを取得.
     * <BR><BR>
     * 接続先のアドレスを取得します.
     * <BR>
     * @return InetAddress 接続先アドレスが返されます.
     */
    public InetAddress getInetAddress() ;
    
    /**
     * 接続先ポート番号を取得.
     * <BR><BR>
     * 接続先ポート番号を取得します.
     * <BR>
     * @return int 接続先ポート番号が返されます.
     */
    public int getPort() ;
    
    /**
     * 接続ユーザの管理者権限を取得.
     * <BR><BR>
     * 接続ユーザの管理者権限を取得します.
     * <BR>
     * @return boolean 権限情報が返されます.<BR>
     *                 [true]が返された場合、コネクションユーザは管理者です.<BR>
     *                 [false]が返された場合、コネクションユーザは、一般ユーザです.
     */
    public boolean isRootOwner() ;
    
    /**
     * オープン中かチェック.
     * <BR><RB>
     * 対象の管理者接続情報がオープン中であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、オープン中です.<BR>
     *                 [false]が返された場合、クローズしています.
     */
    public boolean isOpen() ;
}

