/*
 * @(#)CreateConnectInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import java.net.InetAddress;

/**
 * コネクション生成情報.
 * <BR><BR>
 * コネクション生成情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class CreateConnectInfo implements Comparable {
    
    /**
     * コネクション名.
     */
    private String name = null ;
    
    /**
     * MQキャッシュ名.
     */
    private String mqCacheName = null ;
    
    /**
     * コネクションバッファ長.
     */
    private int buffer = -1 ;
    
    /**
     * バインドアドレス.
     */
    private InetAddress bindAddress = null ;
    
    /**
     * バインドポート.
     */
    private int bindPort = -1 ;
    
    /**
     * 暗号フラグ.
     */
    private boolean cb32 = false ;
    
    /**
     * 暗号文字列.
     */
    private String[] cb32Word = null ;
    
    /**
     * コンストラクタ.
     */
    public CreateConnectInfo() {
        
    }

    /**
     * bindAddress を取得.
     * <BR><BR>
     * @return bindAddress が返されます.
     */
    public InetAddress getBindAddress() {
        return bindAddress;
    }

    /**
     * bindAddress を設定.
     * <BR><BR>
     * @param bindAddress bindAddress を設定します.
     */
    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    /**
     * bindPort を取得.
     * <BR><BR>
     * @return bindPort が返されます.
     */
    public int getBindPort() {
        return bindPort;
    }

    /**
     * bindPort を設定.
     * <BR><BR>
     * @param bindPort bindPort を設定します.
     */
    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    /**
     * buffer を取得.
     * <BR><BR>
     * @return buffer が返されます.
     */
    public int getBuffer() {
        return buffer;
    }

    /**
     * buffer を設定.
     * <BR><BR>
     * @param buffer buffer を設定します.
     */
    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    /**
     * mqCacheName を取得.
     * <BR><BR>
     * @return mqCacheName が返されます.
     */
    public String getMqCacheName() {
        return mqCacheName;
    }

    /**
     * mqCacheName を設定.
     * <BR><BR>
     * @param mqCacheName mqCacheName を設定します.
     */
    public void setMqCacheName(String mqCacheName) {
        this.mqCacheName = mqCacheName;
    }

    /**
     * name を取得.
     * <BR><BR>
     * @return name が返されます.
     */
    public String getName() {
        return name;
    }

    /**
     * name を設定.
     * <BR><BR>
     * @param name name を設定します.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * cb32 を取得.
     * <BR><BR>
     * @return cb32 が返されます.
     */
    public boolean isCb32() {
        return cb32;
    }

    /**
     * cb32 を設定.
     * <BR><BR>
     * @param cb32 cb32 を設定します.
     */
    public void setCb32(boolean cb32) {
        this.cb32 = cb32;
    }
    
    /**
     * cb32Word を取得.
     * <BR><BR>
     * @return cb32Word が返されます.
     */
    public String[] getCb32Word() {
        return cb32Word;
    }

    /**
     * cb32Word を設定.
     * <BR><BR>
     * @param cb32Word cb32Word を設定します.
     */
    public void setCb32Word(String[] cb32Word) {
        this.cb32Word = cb32Word;
    }

    /**
     * オブジェクト比較.
     * <BR><BR>
     * オブジェクトを比較します.
     * <BR>
     * @param o 比較元のオブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo(Object o) {
        
        return name.compareTo( ( ( CreateConnectInfo )o ).name ) ;
        
    }

}

