/*
 * @(#)ReceiveTimeoutException.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.net ;

import org.maachang.queue.access.MaachangQErrorCode;
import org.maachang.queue.access.MaachangQException;

/**
 * 受信タイムアウト例外.
 *  
 * @version 2007/01/08
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class ReceiveTimeoutException extends MaachangQException {
    
    /**
     * シリアライズID.
     */
    private static final long serialVersionUID = -4044126947138944241L;
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します.
     */
    public ReceiveTimeoutException( Throwable e ) {
        super(e) ;
        super.errorCode = MaachangQErrorCode.WARNING_TIMEOUT ;
    }
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param message スローエラー生成時のメッセージを設定します.
     */
    public ReceiveTimeoutException( String message ) {
        super(message) ;
        super.errorCode = MaachangQErrorCode.WARNING_TIMEOUT ;
    }
    
}
