/*
 * @(#)SSLOption.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.net ;


/**
 * SSLオプション.
 * <BR><BR>
 * SSLオプションを示すオブジェクト.
 * 
 * @version 2007/01/11
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class SSLOption {
    
    /**
     * デフォルトストア.
     */
    public static final String DEFAULT_STORE = "JKS" ;
    
    /**
     * デフォルトマネージャアルゴリズム.
     */
    public static final String DEFAULT_MANAGER_ALGORITHM = "SunX509" ;
    
    /**
     * デフォルトSSLプロトコル.
     */
    public static final String DEFAULT_SSL_PROTOCOL = "TLS" ;
    
    
    
    /**
     * キーストアタイプ.
     */
    private String keyStore = DEFAULT_STORE ;
    
    /**
     * トラストストアタイプ.
     */
    private String trustStore = DEFAULT_STORE ;
    
    /**
     * キーストアパスワード.
     */
    private String keyStorePasswd = null ;
    
    /**
     * トラストストアパスワード.
     */
    private String trustPassword = null ;
    
    /**
     * キーストアマネージャアルゴリズム.
     */
    private String keyManagerAlgorithm = DEFAULT_MANAGER_ALGORITHM ;
    
    /**
     * トラストストアマネージャアルゴリズム.
     */
    private String trustKeyManagerAlgorithm = DEFAULT_MANAGER_ALGORITHM ;
    
    /**
     * SSLプロトコル.
     */
    private String sslProtocol = DEFAULT_SSL_PROTOCOL ;
    
    /**
     * 乱数アルゴリズム(PRNG).
     */
    private String randomAlgorithm = null ;
    
    /**
     * キーストアファイル名.
     */
    private String keyStoreFile = null ;
    
    /**
     * トラストストアキーファイル名.
     */
    private String trustFile = null ;
    
    /**
     * コンストラクタ.
     */
    public SSLOption() {
        
    }

    /**
     * キーストアマネージャアルゴリズム を取得.
     * <BR><BR>
     * @return キーストアマネージャアルゴリズム が返されます.
     */
    public String getKeyManagerAlgorithm() {
        return keyManagerAlgorithm;
    }

    /**
     * キーストアマネージャアルゴリズム を設定.
     * <BR><BR>
     * @param keyManagerAlgorithm キーストアマネージャアルゴリズム を設定します.
     */
    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        if( keyManagerAlgorithm == null ||
            ( keyManagerAlgorithm = keyManagerAlgorithm.trim() ).length() <= 0 ) {
            return ;
        }
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    /**
     * トラストストアマネージャアルゴリズム を取得.
     * <BR><BR>
     * @return トラストストアマネージャアルゴリズム が返されます.
     */
    public String getTrustKeyManagerAlgorithm() {
        return trustKeyManagerAlgorithm;
    }

    /**
     * トラストストアマネージャアルゴリズム を設定.
     * <BR><BR>
     * @param trustKeyManagerAlgorithm トラストストアマネージャアルゴリズム を設定します.
     */
    public void setTrustKeyManagerAlgorithm(String trustKeyManagerAlgorithm) {
        if( trustKeyManagerAlgorithm == null ||
            ( trustKeyManagerAlgorithm = trustKeyManagerAlgorithm.trim() ).length() <= 0 ) {
            return ;
        }
        this.trustKeyManagerAlgorithm = trustKeyManagerAlgorithm;
    }

    /**
     * キーストアタイプ を取得.
     * <BR><BR>
     * @return キーストアタイプ が返されます.
     */
    public String getKeyStore() {
        return keyStore;
    }

    /**
     * キーストアタイプ を設定.
     * <BR><BR>
     * @param keyStore キーストアタイプ を設定します.
     */
    public void setKeyStore(String keyStore) {
        if( keyStore == null ||
            ( keyStore = keyStore.trim() ).length() <= 0 ) {
            return ;
        }
        this.keyStore = keyStore;
    }

    /**
     * トラストストアタイプ を取得.
     * <BR><BR>
     * @return トラストストアタイプ が返されます.
     */
    public String getTrustStore() {
        return trustStore;
    }

    /**
     * トラストストアタイプ を設定.
     * <BR><BR>
     * @param trustStore トラストストアタイプ を設定します.
     */
    public void setTrustStore(String trustStore) {
        if( trustStore == null ||
            ( trustStore = trustStore.trim() ).length() <= 0 ) {
            return ;
        }
        this.trustStore = trustStore;
    }

    /**
     * キーストアファイル名 を取得.
     * <BR><BR>
     * @return キーストアファイル名 が返されます.
     */
    public String getKeyStoreFile() {
        return keyStoreFile;
    }

    /**
     * キーストアファイル名 を設定.
     * <BR><BR>
     * @param keyStoreFile キーストアファイル名 を設定します.
     */
    public void setKeyStoreFile(String keyStoreFile) {
        if( keyStoreFile == null ||
            ( keyStoreFile = keyStoreFile.trim() ).length() <= 0 ) {
            return ;
        }
        this.keyStoreFile = keyStoreFile;
    }

    /**
     * キーストアパスワード を取得.
     * <BR><BR>
     * @return キーストアパスワード が返されます.
     */
    public String getKeyStorePasswd() {
        return keyStorePasswd;
    }

    /**
     * キーストアパスワード を設定.
     * <BR><BR>
     * @param keyStorePasswd キーストアパスワード を設定します.
     */
    public void setKeyStorePasswd(String keyStorePasswd) {
        this.keyStorePasswd = keyStorePasswd;
    }

    /**
     * トラストストアパスワード を取得.
     * <BR><BR>
     * @return トラストストアパスワード が返されます.
     */
    public String getTrustPassword() {
        return trustPassword;
    }

    /**
     * トラストストアパスワード を設定.
     * <BR><BR>
     * @param trustPassword トラストストアパスワード を設定します.
     */
    public void setTrustPassword(String trustPassword) {
        this.trustPassword = trustPassword;
    }

    /**
     * 乱数アルゴリズム(PRNG) を取得.
     * <BR><BR>
     * @return 乱数アルゴリズム(PRNG) が返されます.
     */
    public String getRandomAlgorithm() {
        return randomAlgorithm;
    }

    /**
     * 乱数アルゴリズム(PRNG) を設定.
     * <BR><BR>
     * @param randomAlgorithm 乱数アルゴリズム(PRNG) を設定します.
     */
    public void setRandomAlgorithm(String randomAlgorithm) {
        if( randomAlgorithm == null ||
            ( randomAlgorithm = randomAlgorithm.trim() ).length() <= 0 ) {
            return ;
        }
        this.randomAlgorithm = randomAlgorithm;
    }

    /**
     * SSLプロトコル を取得.
     * <BR><BR>
     * @return SSLプロトコル が返されます.
     */
    public String getSslProtocol() {
        return sslProtocol;
    }

    /**
     * SSLプロトコル を設定.
     * <BR><BR>
     * @param sslProtocol SSLプロトコル を設定します.
     */
    public void setSslProtocol(String sslProtocol) {
        if( sslProtocol == null ||
            ( sslProtocol = sslProtocol.trim() ).length() <= 0 ) {
            return ;
        }
        this.sslProtocol = sslProtocol;
    }

    /**
     * トラストストアキーファイル名 を取得.
     * <BR><BR>
     * @return トラストストアファイル名 が返されます.
     */
    public String getTrustFile() {
        return trustFile;
    }

    /**
     * トラストストアキーファイル名 を設定.
     * <BR><BR>
     * @param trustFile トラストストアファイル名 を設定します.
     */
    public void setTrustFile(String trustFile) {
        if( trustFile == null ||
            ( trustFile = trustFile.trim() ).length() <= 0 ) {
            return ;
        }
        this.trustFile = trustFile;
    }
    
    
}

