/*
 * @(#)BaseProtocolBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol ;

/**
 * 基本プロトコルBean.
 *  
 * @version 2007/01/06
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class BaseProtocolBean {
    
    /**
     * 電文ID.
     */
    protected int id = -1 ;
    
    /**
     * 処理タイプ.
     */
    protected int type = -1 ;
    
    /**
     * キューマネージャ名.
     */
    protected String queueManager = null ;
    
    /**
     * キュー名.
     */
    protected String queue = null ;
    
    /**
     * キュータイプ.
     */
    protected int queueType = -1 ;
    
    /**
     * コンストラクタ.
     */
    public BaseProtocolBean() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        queueManager = null ;
        queue = null ;
    }

    /**
     * id を取得.
     * <BR><BR>
     * @return id が返されます.
     */
    public int getId() {
        return id;
    }

    /**
     * id を設定.
     * <BR><BR>
     * @param id id を設定します.
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * type を取得.
     * <BR><BR>
     * @return type が返されます.
     */
    public int getType() {
        return type;
    }

    /**
     * type を設定.
     * <BR><BR>
     * @param type type を設定します.
     */
    public void setType(int type) {
        this.type = type;
    }

    /**
     * queueManager を取得.
     * <BR><BR>
     * @return queueManager が返されます.
     */
    public String getQueueManager() {
        return queueManager;
    }

    /**
     * queueManager を設定.
     * <BR><BR>
     * @param queueManager queueManager を設定します.
     */
    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    /**
     * queue を取得.
     * <BR><BR>
     * @return queue が返されます.
     */
    public String getQueue() {
        return queue;
    }

    /**
     * queue を設定.
     * <BR><BR>
     * @param queue queue を設定します.
     */
    public void setQueue(String queue) {
        this.queue = queue;
    }

    /**
     * queueType を取得.
     * <BR><BR>
     * @return queueType が返されます.
     */
    public int getQueueType() {
        return queueType;
    }

    /**
     * queueType を設定.
     * <BR><BR>
     * @param queueType queueType を設定します.
     */
    public void setQueueType(int queueType) {
        this.queueType = queueType;
    }
    
}
