/*
 * @(#)AdminConnectBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol.admin ;

import java.net.InetAddress;

/**
 * 管理者用コネクションBean.
 *  
 * @version 2007/01/05
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class AdminConnectBean extends BaseAdminProtocolBean {
    
    /**
     * バインドアドレス.
     */
    private String address = null ;
    
    /**
     * バインドポート.
     */
    private int port = -1 ;
    
    /**
     * キャッシュ名.
     */
    private String cacheName = null ;
    
    /**
     * 通信バッファ長.
     */
    private int buffer = -1 ;
    
    /**
     * 暗号フラグ.
     */
    private boolean cb32 = false ;
    
    /**
     * コンストラクタ.
     */
    public AdminConnectBean() {
        
    }
    
    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public InetAddress getInetAddress() {
        if( address != null ) {
            try {
                return InetAddress.getByName( address ) ;
            } catch( Exception e ) {
            }
        }
        return null ;
    }

    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public String getAddress() {
        return address;
    }

    /**
     * address を設定.
     * <BR><BR>
     * @param address address を設定します.
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * buffer を取得.
     * <BR><BR>
     * @return buffer が返されます.
     */
    public int getBuffer() {
        return buffer;
    }

    /**
     * buffer を設定.
     * <BR><BR>
     * @param buffer buffer を設定します.
     */
    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    /**
     * cacheName を取得.
     * <BR><BR>
     * @return cacheName が返されます.
     */
    public String getCacheName() {
        return cacheName;
    }

    /**
     * cacheName を設定.
     * <BR><BR>
     * @param cacheName cacheName を設定します.
     */
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * cb32 を取得.
     * <BR><BR>
     * @return cb32 が返されます.
     */
    public boolean isCb32() {
        return cb32;
    }

    /**
     * cb32 を設定.
     * <BR><BR>
     * @param cb32 cb32 を設定します.
     */
    public void setCb32(boolean cb32) {
        this.cb32 = cb32;
    }


}
