/*
 * @(#)ChannelStatus.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.status ;

/**
 * チャネルステータス.
 * <BR><BR>
 * チャネルのステータスを表します.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class ChannelStatus {
    
    /**
     * チャネルステータス : 正常.
     */
    public static final int STATE_SUCCESS = StatusDefine.STATE_SUCCESS ;
    
    /**
     * チャネルステータス : 停止.
     */
    public static final int STATE_DOWN = StatusDefine.STATE_DOWN ;
    
    /**
     * チャネルステータス : 起動中.
     */
    public static final int STATE_STARTUP = StatusDefine.STATE_STARTUP ;
    
    /**
     * チャネルステータス : 停止中.
     */
    public static final int STATE_SHUTDOWN = StatusDefine.STATE_SHUTDOWN ;
    
    /**
     * チャネルステータス : 異常.
     */
    public static final int STATE_ERROR = StatusDefine.STATE_ERROR ;
    
    /**
     * チャネルステータス : 計画停止.
     */
    public static final int STATE_PLANNED_STOP = StatusDefine.STATE_CUSTOM_ERROR + 1 ;
    
    /**
     * チャネルステータス : 接続未確立による停止.
     */
    public static final int STATE_NOT_HEART_BEAT = StatusDefine.STATE_CUSTOM_ERROR + 2 ;
    
     /**
     * チャネルステータス : 接続先チャネル非存在による停止.
     */
    public static final int STATE_NOT_CONNECT_CHANNEL = StatusDefine.STATE_CUSTOM_ERROR + 3 ;
    
     /**
     * チャネルステータス : 接続先キューマネージャ非存在による停止.
     */
    public static final int STATE_NOT_QUEUE_MANAGER = StatusDefine.STATE_CUSTOM_ERROR + 4 ;
    
    /**
     * コンストラクタ.
     */
    private ChannelStatus() { }
    
    /**
     * ステータスを文字列に変換.
     * <BR><BR>
     * ステータスを文字列に変換します.
     * <BR>
     * @param state 対象のステータスを設定します.
     * @return String 文字列が返されます.
     */
    public static final String getStateByString( int state ) {
        String ret = StatusDefine.getStateByString( state ) ;
        if( ret == null ) {
            switch( state ) {
                case STATE_PLANNED_STOP :           ret = "計画停止中" ; break ;
                case STATE_NOT_HEART_BEAT :         ret = "ハートビート停止" ; break ;
                case STATE_NOT_CONNECT_CHANNEL :    ret = "ハートビート異常" ; break ;
                case STATE_NOT_QUEUE_MANAGER :      ret = "キューマネージャ異常" ; break ;
            }
        }
        
        return ret ;
    }
}

