/*
 * @(#)QueueCommand.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command ;

import java.net.InetAddress;

import org.maachang.command.core.AnalysisCommand;
import org.maachang.command.core.ConnectParam;
import org.maachang.command.core.QueueParam;
import org.maachang.queue.access.ConnectReceiveMq;
import org.maachang.queue.access.ConnectSendMq;
import org.maachang.queue.access.MaachangQAccessDefine;
import org.maachang.queue.access.MaachangQAccessDriver;
import org.maachang.queue.access.MaachangQManager;
import org.maachang.queue.access.MqValue;

/**
 * キューコマンド.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class QueueCommand {
    
    /**
     * デフォルト受信タイムアウト.
     */
    public static final int DEFAULT_TIMEOUT = 15000 ;
    
    /**
     * 文字変換キャラクタセット.
     */
    public static final String UTF8 = "UTF8" ;
    
    /**
     * 送信回数.
     */
    public static final String SEND_COUNT = "ss" ;
    
    /**
     * 実行条件.
     */
    public static final String EXEC_HEAD = "x" ;
    
    /**
     * キー接頭語.
     */
    public static final String KEY_HEAD = "k" ;
    
    /**
     * 電文寿命.
     */
    public static final String EXPIRE_HEAD = "e" ;
    
    /**
     * プライオリティ.
     */
    public static final String PRIORITY_HEAD = "p" ;
    
    /**
     * データ情報.
     */
    public static final String VALUE_HEAD = "v" ;
    
    /**
     * プロセスID.
     */
    public static final String PROCESS_HEAD = "i" ;
    
    /**
     * ファイル名指定.
     */
    public static final String FILE_NAME = "file:" ;
    
    
    
    /**
     * コンストラクタ.
     */
    public QueueCommand() {
        
    }
    
    /**
     * メイン.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    public static final void main( String[] args )
        throws Exception {
        try {
            String rcv = ( new QueueCommand() ).execution( null,args ) ;
            if( rcv != null ) {
                System.out.println( rcv ) ;
            }
        } catch( Exception e ) {
            AnalysisCommand.outputError( e ) ;
        }
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    public final String execution( String[] out,String[] args )
        throws Exception {
        
        int sendCount = AnalysisCommand.getParamInt( args,SEND_COUNT ) ;
        QueueParam queueParam = AnalysisCommand.getQueueParam( args ) ;
        ConnectParam connParam = AnalysisCommand.analysisConnect( args ) ;
        ExecutionQueueBean bean = this.getExecutionQueueBean( args ) ;
        
        if( sendCount <= 0 ) {
            sendCount = 1 ;
        }
        
        if( connParam == null ) {
            connParam = new ConnectParam() ;
        }
        
        if( connParam.getAddress() == null ||
            connParam.getAddress().length() <= 0 ) {
            connParam.setAddress( AnalysisCommand.LOCAL_HOST ) ;
        }
        if( connParam.getPort() == -1 ) {
            connParam.setPort( MaachangQAccessDefine.TELEGRAM_PORT ) ;
        }
        
        MaachangQManager man = MaachangQAccessDriver.connect(
            false,
            queueParam.getManager(),
            InetAddress.getByName( connParam.getAddress() ),
            connParam.getPort() ) ;
        
        MqValue value = new MqValue() ;
        
        // 送信キューで処理.
        if( queueParam.getType() == MaachangQAccessDefine.TYPE_SEND ) {
            
            System.out.println( "--送信キュー(" +
                queueParam.getQueue() + ")送信開始" ) ;
            
            ConnectSendMq send = man.connectSendQueue(
                queueParam.getQueue() ) ;
            value.setKey( bean.getKey() ) ;
            value.setProcessId( bean.getProcessId() ) ;
            value.setPriority( bean.getPriority() ) ;
            value.setExpire( bean.getExpire() ) ;
            value.setValue( bean.getBinary() ) ;
            
            for( int i = 0 ; i < sendCount ; i ++ ) {
                send.send( value ) ;
            }
            man.commit() ;
            System.out.println( "送信完了" ) ;
            
        }
        // 受信キューで処理.
        else {
            
            // 処理タイプが受信処理の場合.
            if( bean.getExecType() == MaachangQAccessDefine.TYPE_RECEIVE ) {
                
                System.out.println( "--受信キュー(" +
                    queueParam.getQueue() + ")受信開始" ) ;
                
                ConnectReceiveMq receive = man.connectReceiveQueue(
                    queueParam.getQueue() ) ;
                
                value.setKey( bean.getKey() ) ;
                
                receive.receive( value,DEFAULT_TIMEOUT ) ;
                man.commit() ;
                
                if( out != null && out.length > 0 ) {
                    out[ 0 ] = value.getKey() ;
                }
                
                if( bean.getFileName() != null ) {
                    AnalysisCommand.setFile( bean.getFileName(),value.getValue() ) ;
                    System.out.println( "受信完了" ) ;
                }
                else {
                   System.out.println( "受信完了" ) ;
                   return new String( value.getValue(),UTF8 ) ;
                }
                
            }
            // 処理タイプが送信処理の場合.
            else {
                
                System.out.println( "--受信キュー(" +
                    queueParam.getQueue() + ")送信開始" ) ;
                
                ConnectReceiveMq receive = man.connectReceiveQueue(
                    queueParam.getQueue() ) ;
                value.setKey( bean.getKey() ) ;
                value.setProcessId( bean.getProcessId() ) ;
                value.setPriority( bean.getPriority() ) ;
                value.setExpire( bean.getExpire() ) ;
                value.setValue( bean.getBinary() ) ;
                
                for( int i = 0 ; i < sendCount ; i ++ ) {
                    receive.send( value ) ;
                }
                man.commit() ;
                System.out.println( "送信完了" ) ;
                
            }
            
        }
        
        return null ;
    }
    
    /**
     * 実行QueueBeanを設定.
     */
    private final ExecutionQueueBean getExecutionQueueBean( String[] args )
        throws Exception {
        
        ExecutionQueueBean ret = new ExecutionQueueBean() ;
        
        String exec = AnalysisCommand.getHeader( args,EXEC_HEAD ) ;
        
        // 実行タイプを取得.
        if( exec == null || ( exec = exec.trim().toLowerCase() ).length() <= 0 ) {
            ret.setExecType( MaachangQAccessDefine.TYPE_SEND ) ;
        }
        else if( exec.startsWith( AnalysisCommand.TYPE_RECEIVE ) == true ) {
            ret.setExecType( MaachangQAccessDefine.TYPE_RECEIVE ) ;
        }
        else {
            ret.setExecType( MaachangQAccessDefine.TYPE_SEND ) ;
        }
        
        // キーを取得.
        String key = AnalysisCommand.getHeader( args,KEY_HEAD ) ;
        if( key == null || ( key = key.trim().toLowerCase() ).length() <= 0 ) {
            ret.setKey( null ) ;
        }
        else {
            ret.setKey( key ) ;
        }
        
        // 実行タイプが送信タイプの場合.
        if( ret.getExecType() == MaachangQAccessDefine.TYPE_SEND ) {
            
            // Expire値取得.
            String exp = AnalysisCommand.getHeader( args,EXPIRE_HEAD ) ;
            if( exp != null && ( exp = exp.trim() ).length() > 0 ) {
                try {
                    ret.setExpire( Integer.parseInt( exp ) ) ;
                } catch( Exception e ) {
                    ret.setExpire( -1 ) ;
                }
            }
            else {
                ret.setExpire( -1 ) ;
            }
            
            // プライオリティ値取得.
            String pro = AnalysisCommand.getHeader( args,PRIORITY_HEAD ) ;
            if( pro != null && ( pro = pro.trim() ).length() > 0 ) {
                try {
                    ret.setPriority( Integer.parseInt( pro ) ) ;
                } catch( Exception e ) {
                    ret.setPriority( MaachangQAccessDefine.DEFAULT_PRIORITY ) ;
                }
            }
            else {
                ret.setPriority( MaachangQAccessDefine.DEFAULT_PRIORITY ) ;
            }
            
            // プロセスID取得.
            String px = AnalysisCommand.getHeader( args,PROCESS_HEAD ) ;
            if( px != null && ( px = px.trim() ).length() > 0 ) {
                ret.setProcessId( px ) ;
            }
            
            // 送信電文情報を取得.
            String value = AnalysisCommand.getHeader( args,VALUE_HEAD ) ;
            if( value == null || ( value = value.trim() ).length() <= 0 ) {
                throw new IllegalArgumentException( "送信データは存在しません" ) ;
            }
            
            // 送信電文がファイルの場合.
            if( value.toLowerCase().startsWith( FILE_NAME ) == true ) {
                ret.setBinary( AnalysisCommand.getFile(
                        value.substring( FILE_NAME.length() ) ) ) ;
            }
            // 送信電文がファイル以外の場合.
            else {
                ret.setBinary( value.getBytes( UTF8 ) ) ;
            }
            
        }
        // 実行タイプが受信タイプの場合.
        else {
            
            // 受信電文情報を取得.
            String value = AnalysisCommand.getHeader( args,VALUE_HEAD ) ;
            if( value != null && ( value = value.trim() ).length() > 0 ) {
                
                // 受信電文がファイルの場合.
                if( value.toLowerCase().startsWith( FILE_NAME ) == true ) {
                    ret.setFileName( value.substring( FILE_NAME.length() ) ) ;
                }
                
            }
            
        }
        
        return ret ;
        
    }
    
}



