/*
 * @(#)AdminUserCommand.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.admin ;

import org.maachang.command.core.AnalysisCommand;
import org.maachang.command.core.LoginParam;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.admin.AdminUser;
import org.maachang.queue.access.admin.MaachangQConnectAdmin;
import org.maachang.queue.access.admin.info.CreateUserInfo;
import org.maachang.queue.access.admin.info.UserInfo;

/**
 * 管理者用ユーザコマンド.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class AdminUserCommand {
    
    /**
     * 実行条件.
     */
    private static final String EXEC_HEAD = "x" ;
    
    /**
     * ユーザ名.
     */
    private static final String USER_NAME = "u" ;
    
    /**
     * パスワード.
     */
    private static final String PASSWD = "p" ;
    
    /**
     * 権限
     */
    private static final String OWNER = "n" ;
    
    
    /**
     * 実行タイプ : リスト表示.
     * list.
     */
    private static final String EXEC_LIST = "l" ;
    
    /**
     * 実行タイプ : ユーザ生成.
     * create.
     */
    private static final String EXEC_CREATE = "c" ;
    
    /**
     * 実行タイプ : ユーザ削除.
     * remove.
     */
    private static final String EXEC_DELETE = "r" ;
    
    /**
     * 実行タイプ : パスワード変更.
     * passwd.
     */
    private static final String EXEC_PASSWD = "p" ;
    
    /**
     * 実行タイプ : 権限変更.
     * owner.
     */
    private static final String EXEC_OWNER = "o" ;
    
    /**
     * 実行タイプ : ログイン中パスワードの変更.
     * this
     */
    private static final String EXEC_THIS = "t" ;
    
    
    /**
     * コンストラクタ.
     */
    private AdminUserCommand() {
        
    }
    
    /**
     * メイン.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    public static final void main( String[] args )
        throws Exception {
        try {
            new AdminUserCommand().execution( args ) ;
        } catch( Exception e ) {
            AnalysisCommand.outputError( e ) ;
        }
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    private final void execution( String[] args )
        throws Exception {
        
        String exec = this.execType( args ) ;
        String userName = this.getUserName( args ) ;
        String passwd = this.getPasswd( args ) ;
        boolean owner = this.getOwner( args ) ;
        
        MaachangQConnectAdmin admin = AnalysisCommand.loginToConnect( args ) ;
        AdminUser user = admin.getAdminUser() ;
        
        // リスト表示.
        if( EXEC_LIST.equals( exec ) ) {
            UserInfo[] names = user.getUserInfo() ;
            this.outputNames( true,names ) ;
        }
        // 生成.
        else if( EXEC_CREATE.equals( exec ) ) {
            
            if( userName == null || userName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象ユーザ名は存在しません" ) ;
            }
            
            CreateUserInfo info = new CreateUserInfo() ;
            info.setUser( userName ) ;
            info.setRootOwner( owner ) ;
            user.addUser( info,passwd ) ;
            
            System.out.println( userName +
                " ユーザ生成しました" ) ;
        }
        // 削除.
        else if( EXEC_DELETE.equals( exec ) ) {
            
            if( userName == null || userName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象ユーザ名は存在しません" ) ;
            }
            
            user.removeUser( userName ) ;
            
            System.out.println( userName +
                " ユーザ削除しました" ) ;
        }
        // パスワード変更.
        else if( EXEC_PASSWD.equals( exec ) ) {
            
            if( userName == null || userName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象ユーザ名は存在しません" ) ;
            }
            
            user.changePasswd( userName,passwd ) ;
            
            System.out.println( userName +
                " ユーザパスワード変更しました" ) ;
        }
        // 権限変更.
        else if( EXEC_OWNER.equals( exec ) ) {
            
            if( userName == null || userName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象ユーザ名は存在しません" ) ;
            }
            
            user.changeRootOwner( userName,owner ) ;
            
            System.out.println( userName +
                " ユーザ権限変更しました" ) ;
        }
        
        // ログインユーザパスワード変更.
        else if( EXEC_THIS.equals( exec ) ) {
            
            LoginParam loginParam = AnalysisCommand.analysisLogin( args ) ;
            user.changeLoginUserPasswd( loginParam.getPasswd(),passwd ) ;
            
            System.out.println( loginParam.getUser() +
                " ログインユーザパスワード変更しました" ) ;
        }
    }
    
    /**
     * 実行条件を解析.
     */
    private final String execType( String[] args ) {
        String execType = AnalysisCommand.getHeader( args,EXEC_HEAD ) ;
        if( execType == null || ( execType = execType.trim().toLowerCase() ).length() <= 0 ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_LIST ) == true ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_CREATE ) == true ) {
            return EXEC_CREATE ;
        }
        else if( execType.startsWith( EXEC_DELETE ) == true ) {
            return EXEC_DELETE ;
        }
        else if( execType.startsWith( EXEC_PASSWD ) == true ) {
            return EXEC_PASSWD ;
        }
        else if( execType.startsWith( EXEC_OWNER ) == true ) {
            return EXEC_PASSWD ;
        }
        else if( execType.startsWith( EXEC_THIS ) == true ) {
            return EXEC_THIS ;
        }
        else {
            return EXEC_LIST ;
        }
        
    }
    
    /**
     * ユーザ名を取得.
     */
    private final String getUserName( String[] args ) {
        return AnalysisCommand.getParamString( args,USER_NAME ) ;
    }
    
    /**
     * パスワードを取得.
     */
    private final String getPasswd( String[] args ) {
        return AnalysisCommand.getParamString( args,PASSWD ) ;
    }
    
    /**
     * 権限を取得.
     */
    private final boolean getOwner( String[] args ) {
        return AnalysisCommand.getParamBoolean( args,OWNER ) ;
    }
    
    /**
     * 一覧名表示.
     */
    private final void outputNames( boolean mode,UserInfo[] names ) {
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            System.out.println( "----+---------------------------------------------" ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( names[ i ] != null ) {
                    System.out.print( "name:" + names[ i ].getUser() ) ;
                    System.out.println( "\t owner:" + names[ i ].isRootOwner() ) ;
                }
            }
        }
        else if( mode == true ) {
            System.out.println( "not user." ) ;
        }
    }
    
}

