/*
 * @(#)QueueParam.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.core ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * キューパラメータ.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class QueueParam {
    
    private String manager = null ;
    private String queue = null ;
    private int type = MaachangQAccessDefine.TYPE_SEND ;
    /**
     * manager を取得.
     * <BR><BR>
     * @return manager が返されます.
     */
    public String getManager() {
        return manager;
    }
    /**
     * manager を設定.
     * <BR><BR>
     * @param manager manager を設定します.
     */
    public void setManager(String manager) {
        if( manager == null ||
            ( manager = manager.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        this.manager = manager;
    }
    /**
     * queue を取得.
     * <BR><BR>
     * @return queue が返されます.
     */
    public String getQueue() {
        return queue;
    }
    /**
     * queue を設定.
     * <BR><BR>
     * @param queue queue を設定します.
     */
    public void setQueue(String queue) {
        if( queue == null ||
            ( queue = queue.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        this.queue = queue;
    }
    /**
     * type を取得.
     * <BR><BR>
     * @return type が返されます.
     */
    public int getType() {
        return type;
    }
    /**
     * type を設定.
     * <BR><BR>
     * @param type type を設定します.
     */
    public void setType(int type) {
        this.type = type;
    }
    
}

