/*
 * @(#)MaachangSearch.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index ;

import org.maachang.index.core.InsertIndex;
import org.maachang.index.core.element.IndexBase;

/**
 * 検索インデックス生成処理.
 *
 * @version 2007/07/08
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class MaachangIndex {
    
    /**
     * インデックス作成コア処理.
     */
    private InsertIndex insertIndex = null ;
    
    /**
     * コンストラクタ.
     */
    private MaachangIndex() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を設定して、インデックス注入オブジェクトを生成します.
     * <BR>
     * @param n インデックス幅を設定します.
     * @param cache 最大キャッシュサイズを設定します.
     * @param keyCache 最大IndexKeyキャッシュサイズを設定します.
     * @param nameCache 最大IndexNameキャッシュサイズを設定します.
     * @param baseDir インデックス出力用ディレクトリを設定します.
     * @exception Exception 例外.
     */
    public MaachangIndex( int n,int cache,int keyCache,int nameCache,String baseDir )
        throws Exception {
        insertIndex = new InsertIndex( n,cache,keyCache,nameCache,baseDir ) ;
    }
    
    /**
     * インデックスを保存.
     * <BR><BR>
     * インデックスを保存します.
     */
    public void flush() {
        insertIndex.flush() ;
    }
    
    /**
     * 管理バージョンを１つ上げる.
     * <BR><BR>
     * 管理バージョンを１つ上げます.
     */
    public void addVersion() {
        insertIndex.addVersion() ;
    }
    
    /**
     * 検索バージョンを取得.
     * <BR><BR>
     * 現在有効な検索バージョンを取得します.
     * <BR>
     * @return String 検索バージョンが返されます.
     */
    public String getIndexVersion() {
        return String.valueOf( insertIndex.getIndexVersion().getVersion() ) ;
    }
    
    /**
     * インデックスに追加.
     * <BR><BR>
     * インデックスに追加します.
     * <BR>
     * @param name この情報を表す一意名を設定します.
     * @param value 対象の内容を設定します.
     * @param element この情報を表す要素情報を設定します.
     * @exception Exception 例外.
     */
    public void put( String name,String value,String element )
        throws Exception {
        IndexBase bs = new IndexBase( name,value,element,null ) ;
        insertIndex.put( bs ) ;
    }
    
    /**
     * インデックスに追加.
     * <BR><BR>
     * インデックスに追加します.
     * <BR>
     * @param name この情報を表す一意名を設定します.
     * @param value 対象の内容を設定します.
     * @param element この情報を表す要素情報を設定します.
     * @param keys 対象のキー内容を設定します.
     * @exception Exception 例外.
     */
    public void put( String name,String value,String element,String... keys )
        throws Exception {
        IndexBase bs = new IndexBase( name,value,element,keys ) ;
        insertIndex.put( bs ) ;
    }
    
    /**
     * インデックス作成用情報を削除.
     * <BR><BR>
     * インデックス作成用情報を削除します.
     * <BR>
     * @param name 削除対象名を設定します.
     * @exception Exception 例外.
     */
    public void remove( String name ) throws Exception {
        insertIndex.remove( name ) ;
    }
    
    /**
     * 対象条件が存在するかチェック.
     * <BR><BR>
     * 対象条件が存在するかチェックします.
     * <BR>
     * @param name 対象名を設定します.
     * @return boolean チェック結果が返されます.
     */
    public boolean isName( String name ) {
        return ( insertIndex.getNameById( name ) == null ) ? false : true ;
    }
    
    /**
     * インデックスコアオブジェクトを取得.
     * <BR><BR>
     * インデックスコアオブジェクトを取得します.
     * <BR>
     * @return InsertIndex インデックスコアオブジェクトが返されます.
     */
    protected InsertIndex getInsertIndex() {
        return insertIndex ;
    }
}

