/*
 * @(#)SubKey.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index ;

/**
 * サブキー定義.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class SubKey implements Comparable {
    
    /**
     * キーワード項番.
     */
    private int number = -1 ;
    
    /**
     * キーワード.
     */
    private String keyword = null ;
    
    /**
     * コンストラクタ.
     */
    private SubKey() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * サブキーワードを設定します.
     * <BR>
     * @param number 対象のキーワード項番を設定します.
     * @param keyword 対象のキーワード項番を設定します.
     * @exception IllegalArgumentException 入力例外.
     */
    public SubKey( int number,String keyword )
        throws IllegalArgumentException {
        if( number < 0 || keyword == null || ( keyword = keyword.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        
        this.number = number ;
        this.keyword = keyword ;
    }
    
    /**
     * キーワード項番を取得.
     * <BR><BR>
     * キーワード項番を取得します.
     * <BR>
     * @return int キーワード項番が返されます.
     */
    public int getNumber() {
        return this.number ;
    }
    
    /**
     * キーワードを取得.
     * <BR><BR>
     * キーワードを取得します.
     * <BR>
     * @return String キーワードが返されます.
     */
    public String getKeyword() {
        return this.keyword ;
    }
    
    /**
     * 比較処理.
     * <BR><BR>
     * 比較処理を実施します.
     * <BR>
     * @param o 対象のオブジェクト(SubKey)を設定します.
     * @return int 結果が返されます.
     */
    public int compareTo( Object o ) {
        if( o == null || ( o instanceof SubKey ) == false ) {
            return 0 ;
        }
        
        return this.number - ( ( SubKey )o ).number ;
    }
    
    /**
     * 文字列を取得.
     * <BR><BR>
     * オブジェクト内容を文字列として取得します.
     * <BR>
     * @return String 文字列が返されます.
     */
    public String toString() {
        return new StringBuilder().append( keyword ).
            append( " " ).append( number ).toString() ;
    }
}

