/*
 * @(#)IndexDef.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index.core ;

/**
 * Index定義.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class IndexDef {
    
    /**
     * インデックス幅 ; 最小値.
     */
    public static final int MIN_INDEX_N_GRAM = 1 ;
    
    /**
     * インデックス幅 : 最大値.
     */
    public static final int MAX_INDEX_N_GRAM = 3 ;
    
    /**
     * ベースデータ格納ディレクトリ.
     */
    public static final String BASE_DIR = "base" ;
    
    /**
     * インデックス格納ディレクトリ.
     */
    public static final String INDEX_DIR = "index" ;
    
    /**
     * ヒストリ格納ディレクトリ.
     */
    public static final String HISTORY_DIR = "history" ;
    
    /**
     * キー格納ディレクトリ.
     */
    public static final String KEY_DIR = "key" ;
    
    /**
     * 名前格納ディレクトリ.
     */
    public static final String NAME_DIR = "name" ;
    
    /**
     * 検索結果部分文字最大値.
     */
    public static final int SEARCH_PART_LENGTH = 128 ;
    
    /**
     * 表示デフォルト値.
     */
    public static final int DEFAULT_VIEW_LENGTH = 10 ;
    
    /**
     * スコア－係数.
     */
    public static final double SCORE_COEFFICIENT = 0.025f ;
}

