/*
 * @(#)IndexName.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index.core.element ;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import org.maachang.util.ConvertBinary;
import org.maachang.util.Digest;
import org.maachang.util.FileUtil;
import org.maachang.util.ReadBinary;

/**
 * IndexName.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class IndexName {
    
    /**
     * 名前.
     */
    private String name = null ;
    
    /**
     * 対象ID.
     */
    private Long id = null ;
    
    /**
     * データ長.
     */
    private int length = 0 ;
    
    /**
     * コンストラクタ.
     */
    public IndexName() {
        
    }
    
    /**
     * 外部ファイルとして出力.
     * <BR><BR>
     * 外部ファイルとして出力します.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     * @exception Exception 例外.
     */
    public void putSerializable( String baseDir )
        throws Exception {
        if( baseDir.endsWith( "/" ) == true || baseDir.endsWith( "\\" ) == true ) {
            baseDir.substring( 0,baseDir.length()-1 ) ;
        }
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( changeName( name ) ).toString() ;
        BufferedOutputStream o = null ;
        try{
            o = new BufferedOutputStream( new FileOutputStream( file ) ) ;
            toFile( o ) ;
        }catch( Exception e ){
            e.printStackTrace() ;
        }finally{
            try{
                o.close() ;
            }catch( Exception e ){
            }
            o = null ;
        }
    }
    
    /**
     * 外部ファイルから取得.
     * <BR><BR>
     * 外部ファイルがら取得します.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     * @param name 対象の名前を設定します.
     * @return IndexName オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final IndexName getSerializable( String baseDir,String name )
        throws Exception {
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( changeName( name ) ).toString() ;
        if( FileUtil.isFileExists( file ) == false ) {
            return null ;
        }
        BufferedInputStream in = null ;
        try{
            in = new BufferedInputStream(
                new FileInputStream( file )
            ) ;
            IndexName ret = new IndexName() ;
            ret.toObject( in ) ;
            return ret ;
        }catch( Exception e ){
            e.printStackTrace() ;
        }finally{
            try{
                in.close() ;
            }catch( Exception e ){
            }
            in = null ;
        }
        return null ;
    }
    
    /**
     * 対象ファイルを削除.
     * <BR><BR>
     * 対象のファイルを削除します.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     * @param name 対象の名前を設定します.
     */
    public static final void removeSerializable( String baseDir,String name ) {
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( changeName( name ) ).toString() ;
        if( FileUtil.isFileExists( file ) == true ) {
            FileUtil.removeFile( file ) ;
        }
    }
    
    /**
     * 条件が存在するかチェック.
     * <BR><BR>
     * 条件が存在するかチェックします.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     * @param name 対象の名前を設定します.
     * @return boolean チェック結果が返されます.
     */
    public static final boolean isUse( String baseDir,String name ) {
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( changeName( name ) ).toString() ;
        return FileUtil.isFileExists( file ) ;
    }
    
    /**
     * 名前を設定.
     * <BR><BR>
     * 名前を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     */
    public void setName( String name ) {
        this.name = name ;
    }
    
    /**
     * 名前を取得.
     * <BR><BR>
     * 名前を取得します.
     * <BR>
     * @return String 名前が返されます.
     */
    public String getName() {
        return this.name ;
    }
    
    /**
     * IDを設定.
     * <BR><BR>
     * IDを設定します.
     * <BR>
     * @param id 対象IDを設定します.
     */
    public void setId( Long id ) {
        this.id = id ;
    }
    
    /**
     * IDを取得.
     * <BR><BR>
     * IDを取得します.
     * <BR>
     * @return Long IDが返されます.
     */
    public Long getId() {
        return this.id ;
    }
    
    /**
     * データ長を設定.
     * <BR><BR>
     * データ長を設定します.
     * <BR>
     * @param length データ長を設定します.
     */
    public void setLength( int length ) {
        this.length = length ;
    }
    
    /**
     * データ長を取得.
     * <BR><BR>
     * データ長を取得します.
     * <BR>
     * @return int データ長を取得します.
     */
    public int getLength() {
        return this.length ;
    }
    
    /**
     * 指定名を変換.
     */
    protected static final String changeName( String name ) {
        try {
            byte[] bin = name.getBytes( "UTF8" ) ;
            return new StringBuilder().append( Digest.convert( "SHA1",bin ) ).
                append( "_" ).append( name.hashCode() ).append( "." ).
                append( name.length() ).toString() ;
        } catch( Exception e ) {
        }
        return null ;
    }
    
    /**
     * オブジェクトをファイル化.
     */
    private void toFile( BufferedOutputStream bo )
        throws Exception {
        byte[] bin = null ;
        bin = ConvertBinary.convertString( name ) ;
        bo.write( ConvertBinary.convertInt( bin.length ) ) ;
        bo.write( bin ) ;bin = null ;
        bo.write( ConvertBinary.convertLong( id.longValue() ) ) ;
        bo.write( ConvertBinary.convertInt( length ) ) ;
        bo.flush() ;
    }
    
    /**
     * ファイルからオブジェクトに変換.
     */
    private void toObject( BufferedInputStream bi )
        throws Exception {
        int len ;
        ReadBinary r = new ReadBinary( bi ) ;
        len = ConvertBinary.convertInt( 0,r.getBinary( 4 ) ) ;
        name = ConvertBinary.convertString( 0,len,r.getBinary( len ) ) ;
        id = new Long( ConvertBinary.convertLong( 0,r.getBinary( 8 ) ) ) ;
        length = ConvertBinary.convertInt( 0,r.getBinary( 4 ) ) ;
    }
}

