/*
 * @(#)ReadBinary.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.util ;

import java.io.InputStream;

/**
 * バイナリを取得.
 *
 * @version 2007/05/19
 * @author  masahito suzuki
 * @since   MaachangSync 1.00
 */
public class ReadBinary {
    
    /**
     * バイナリ取得元.
     */
    private InputStream input = null ;
    
    /**
     * コンストラクタ.
     */
    private ReadBinary() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * オブジェクトを設定します.
     * <BR>
     * @param input 対象のオブジェクトを設定します.
     */
    public ReadBinary( InputStream input ) {
        this.input = input ;
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public void clear() {
        input = null ;
    }
    
    /**
     * 対象バイナリ長取得.
     * <BR><BR>
     * 対象バイナリ長データを取得します.
     * <BR>
     * @param length 取得データ長を設定します.
     * @return byte[] 対象バイナリ情報が返されます.
     * @exception Exception 例外.
     */
    public byte[] getBinary( int length )
        throws Exception {
        if( length <= 0 ) {
            return null ;
        }
        byte[] ret = new byte[ length ] ;
        input.read( ret,0,length ) ;
        return ret ;
    }
}

