/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.engine.MDbmEngine;
import org.maachang.dbm.engine.MHash;
import org.maachang.dbm.engine.MKey;
import org.maachang.dbm.engine.MSctArray;
import org.maachang.dbm.engine.MValue;
import org.maachang.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MDbmImpl
implements MDbm {
    private static final String BASE_FILE = "base.hash";
    private static final String KEY_FILE = "key.hash";
    private MDbmEngine engine = null;
    private String directory = null;

    private MDbmImpl() {
    }

    public MDbmImpl(String directory) throws Exception {
        MDbmEngine engine;
        if (directory == null || (directory = directory.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if ((directory = FileUtil.getFullPath(directory)).endsWith("\\") || directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (!FileUtil.isDirExists(directory)) {
            FileUtil.mkdirs(directory);
        }
        MHash hash = new MHash(directory + FileUtil.FILE_SPACE + BASE_FILE);
        MKey key = new MKey(hash, directory + FileUtil.FILE_SPACE + KEY_FILE);
        MValue value = new MValue(new MSctArray(directory));
        this.engine = engine = new MDbmEngine(key, value);
        this.directory = directory;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        if (this.engine != null) {
            this.engine.destroy();
        }
        this.engine = null;
        this.directory = null;
    }

    protected void flush() throws Exception {
        if (!this.isUse()) {
            return;
        }
        if (this.engine != null) {
            this.engine.flush();
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void commit() throws Exception {
    }

    @Override
    public void rollback() throws Exception {
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void put(byte[] key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.engine.put(key, value);
    }

    @Override
    public void remove(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.engine.remove(key);
    }

    @Override
    public byte[] get(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.engine.get(key);
    }

    @Override
    public boolean containsKey(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.engine.containsKey(key);
    }

    @Override
    public Enumeration<byte[]> elements() {
        if (!this.isUse()) {
            return null;
        }
        return this.engine.elements();
    }

    @Override
    public long sequenceId(int no) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.engine.sequenceId(no);
    }

    @Override
    public int size() {
        if (!this.isUse()) {
            return -1;
        }
        return this.engine.size();
    }

    @Override
    public String getDirectory() {
        if (!this.isUse()) {
            return null;
        }
        return this.directory;
    }

    protected MDbmEngine getEngine() {
        if (!this.isUse()) {
            return null;
        }
        return this.engine;
    }

    @Override
    public boolean isUse() {
        if (this.engine == null) {
            return false;
        }
        return this.engine.isUse();
    }

    protected Object sync() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sectorFile() {
        if (this.engine != null) {
            Object object = this.sync();
            synchronized (object) {
                return this.engine.getMValue().getArray().size();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int useSector() {
        if (this.engine != null) {
            Object object = this.sync();
            synchronized (object) {
                return this.engine.getMValue().getArray().useSector();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int maxSector() {
        if (this.engine != null) {
            Object object = this.sync();
            synchronized (object) {
                return this.engine.getMValue().getArray().maxSector();
            }
        }
        return -1;
    }

    protected long freeSpace() {
        if (this.engine != null) {
            return new File(this.directory).getFreeSpace();
        }
        return -1L;
    }

    @Override
    public boolean isTransaction() {
        return false;
    }
}

