/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.maachang.dbm.engine.MSctArray;
import org.maachang.dbm.engine.MSector;
import org.maachang.dbm.engine.ValueSector;

public class MValue {
    private MSctArray sectors = null;
    private final Object sync = new Object();

    private MValue() {
    }

    public MValue(MSctArray sectors) throws Exception {
        if (sectors == null || !sectors.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.sectors = sectors;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sectors != null) {
                this.sectors.destroy();
            }
            this.sectors = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.sectors.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putCheck(int length) throws Exception {
        if (length <= 0) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            block10: {
                int sec;
                block9: {
                    int rem;
                    block8: {
                        if (!this.check()) {
                            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                        }
                        rem = length - this.sectors.useSector();
                        if (rem > -1) break block8;
                        return true;
                    }
                    sec = ((rem & 0xFFFF0000) >> 16) + ((rem & 0xFFFF) != 0 ? 1 : 0);
                    if (sec + this.sectors.size() < 1024) break block9;
                    return false;
                }
                long all = MSector.oneSectorFileSize() * (long)sec;
                long sz = new File(this.sectors.getDirectory()).getFreeSpace();
                if (all < sz) break block10;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] put(byte[] binary) throws Exception {
        if (binary == null || binary.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        MSctArray ary = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ary = this.sectors;
        }
        int binLen = binary.length;
        int secLen = MSctArray.sectorLength(binLen);
        if (secLen * 2 >= ary.useSector()) {
            ary.add();
        }
        MSector sector = null;
        ArrayList<ValueSector> cache = new ArrayList<ValueSector>();
        int secCnt = secLen;
        int i = 0;
        while (i < secLen) {
            if (sector == null) {
                sector = MValue.getUseObject(ary, secCnt);
            }
            ValueSector value = new ValueSector();
            sector = MValue.addSector(ary, sector, value, secCnt);
            cache.add(value);
            ary.removeUseSector();
            ++i;
            --secCnt;
        }
        int[] ret = new int[2];
        int len = cache.size();
        int offset = 0;
        ValueSector bef = null;
        int i2 = 0;
        while (i2 < len) {
            ValueSector now = (ValueSector)cache.get(i2);
            if (bef == null) {
                ret[0] = now.getFileNo();
                ret[1] = now.getPosition();
            }
            int oneLen = binLen >= 8192 ? 8192 : binLen;
            now.write(binary, 0, offset, oneLen);
            offset += oneLen;
            binLen -= oneLen;
            if (bef != null) {
                now.setBeforeFileNo(bef.getFileNo());
                now.setBeforeFilePos(bef.getPosition());
                bef.setNextFileNo(now.getFileNo());
                bef.setNextFilePos(now.getPosition());
                sector = ary.get(bef.getFileNo());
                sector.put(bef.getPosition(), bef);
            }
            bef = now;
            now = null;
            ++i2;
        }
        sector = ary.get(bef.getFileNo());
        sector.put(bef.getPosition(), bef);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int fileNo, int filePos) throws Exception {
        MSctArray ary = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ary = this.sectors;
        }
        MSector sector = null;
        while (true) {
            if (sector == null && (sector = ary.get(fileNo)) == null) {
                throw new IOException("\u6307\u5b9a\u30bb\u30af\u30bf\u30fc[fileNo:" + fileNo + " filePos:" + filePos + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            ValueSector val = sector.remove(filePos);
            if (val == null || val.getLength() <= 0) {
                throw new IOException("\u6307\u5b9a\u6761\u4ef6(fileNo:" + fileNo + " filePos:" + filePos + ")\u306f\u4e0d\u6b63\u306a\u6761\u4ef6\u3067\u3059");
            }
            ary.addUseSector();
            fileNo = val.getNextFileNo();
            filePos = val.getNextFilePos();
            if (fileNo <= -1 || filePos <= -1) break;
            if (val.getFileNo() == fileNo) continue;
            sector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(int fileNo, int filePos) throws Exception {
        MSctArray ary = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ary = this.sectors;
        }
        MSector sector = null;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        while (true) {
            if (sector == null && (sector = ary.get(fileNo)) == null) {
                throw new IOException("\u6307\u5b9a\u30bb\u30af\u30bf\u30fc[fileNo:" + fileNo + " filePos:" + filePos + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            ValueSector val = sector.get(filePos);
            if (val == null || val.getLength() <= 0) {
                throw new IOException("\u6307\u5b9a\u6761\u4ef6(fileNo:" + fileNo + " filePos:" + filePos + ")\u306f\u4e0d\u6b63\u306a\u6761\u4ef6\u3067\u3059");
            }
            byte[] b = val.read();
            if (b == null) {
                throw new IOException("\u6307\u5b9a\u6761\u4ef6(fileNo:" + fileNo + " filePos:" + filePos + ")\u306b\u306f\u3001\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            bo.write(b, 0, b.length);
            fileNo = val.getNextFileNo();
            filePos = val.getNextFilePos();
            if (fileNo <= -1 || filePos <= -1) break;
            if (val.getFileNo() == fileNo) continue;
            sector = null;
        }
        bo.flush();
        byte[] ret = bo.toByteArray();
        bo.close();
        bo = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MSctArray getArray() {
        MSctArray ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? null : this.sectors;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.check();
        }
        return ret;
    }

    private boolean check() {
        return this.sectors != null;
    }

    private static final MSector getUseObject(MSctArray ary, int secLen) throws Exception {
        MSector ret = null;
        while ((ret = ary.getMaxUseObject(secLen)) == null) {
            ary.add();
        }
        return ret;
    }

    private static final MSector addSector(MSctArray ary, MSector sector, ValueSector value, int secLen) throws Exception {
        while (!sector.add(value)) {
            sector = MValue.getUseObject(ary, secLen);
        }
        return sector;
    }
}

