/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.io.IOException;
import java.net.InetAddress;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.AcceptThread;
import org.maachang.dbm.service.PoolThread;
import org.maachang.dbm.service.ReceiveQueue;
import org.maachang.dbm.service.ReceiveThread;
import org.maachang.dbm.service.SocketManager;

public class MDbmServer {
    private static final int MIN_POOL = 1;
    private static final int MAX_POOL = 127;
    private SocketManager conns = null;
    private ReceiveQueue queue = null;
    private AcceptThread accepts = null;
    private ReceiveThread receives = null;
    private PoolThread[] pools = null;

    private MDbmServer() {
    }

    public MDbmServer(InetAddress addr, int port, int backlog, int pool) throws Exception {
        if (MDbmManager.getInstance().isClose()) {
            throw new IOException("MaachangDbm\u306f\u958b\u59cb\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        if (pool <= 1) {
            pool = 1;
        }
        if (pool >= 127) {
            pool = 127;
        }
        try {
            this.conns = new SocketManager(addr, port, backlog);
            this.queue = new ReceiveQueue();
            this.accepts = new AcceptThread(this.conns);
            this.receives = new ReceiveThread(this.conns, this.queue);
            this.pools = new PoolThread[pool];
            int i = 0;
            while (i < pool) {
                this.pools[i] = new PoolThread(this.conns, this.queue);
                ++i;
            }
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.accepts != null) {
            this.accepts.destroy();
        }
        if (this.receives != null) {
            this.receives.destroy();
        }
        if (this.pools != null) {
            int len = this.pools.length;
            int i = 0;
            while (i < len) {
                if (this.pools[i] != null) {
                    this.pools[i].destroy();
                }
                ++i;
            }
        }
        if (this.queue != null) {
            this.queue.destroy();
        }
        if (this.conns != null) {
            this.conns.destroy();
        }
    }

    public InetAddress getInetAddress() {
        if (this.conns != null) {
            return this.conns.getServerSocket().getInetAddress();
        }
        return null;
    }

    public int getLocalPort() {
        if (this.conns != null) {
            return this.conns.getServerSocket().getLocalPort();
        }
        return -1;
    }

    public int size() {
        if (this.conns != null) {
            return this.conns.size();
        }
        return -1;
    }

    public boolean isUse() {
        if (this.conns == null || this.queue == null || this.accepts == null || this.receives == null || this.pools == null) {
            return false;
        }
        return !this.conns.isClosed();
    }
}

