/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpdCookie {
    public static final String GET_COOKIE = "Cookie";
    public static final String SET_COOKIE = "Set-Cookie";

    public static final String createCookie(String key, String value, String path) throws Exception {
        return HttpdCookie.createCookie(key, value, path, Long.MIN_VALUE);
    }

    public static final String createCookie(String key, String value, String path, long expire) throws Exception {
        if (key == null || (key = key.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            throw new IllegalArgumentException("key\u53ca\u3073value\u306f\u5fc5\u9808\u6761\u4ef6\u3067\u3059");
        }
        if (key.indexOf("=") != -1) {
            throw new IllegalArgumentException("key\u540d[" + key + "]\u306b\u306f\u4e0d\u6b63\u306a\u6587\u5b57\u304c\u683c\u7d0d\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(key).append("=").append(value).append(";");
        if (path != null && (path = path.trim()).length() > 0) {
            buf.append(" path=").append(path).append(";");
        }
        if (expire != Long.MIN_VALUE) {
            buf.append(" expires=").append(HttpdTimestamp.getTimestamp(true, expire)).append(";");
        }
        return buf.toString();
    }

    public static final HashMap<String, String> analysisCookie(String cookie) throws Exception {
        if (cookie == null || (cookie = cookie.trim()).length() <= 0) {
            throw new IllegalArgumentException("Cookie\u60c5\u5831\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ArrayList lst = StringUtil.cutString((boolean)true, (boolean)false, (String)cookie, (String)":; =");
        if (lst == null || lst.size() <= 0) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        int len = lst.size();
        int i = 0;
        while (i < len) {
            String key = ((String)lst.get(i)).trim();
            String value = (String)lst.get(i + 1);
            ret.put(key, value);
            i += 2;
        }
        return ret;
    }

    public static final void putCookie(HttpdResponse response, String cookie) {
        if (response == null || cookie == null || (cookie = cookie.trim()).length() <= 0) {
            return;
        }
        HttpdHeaders header = response.getHeader();
        header.addHeader(SET_COOKIE, cookie);
    }

    public static final String getCookie(HttpdRequest request) {
        if (request == null) {
            return null;
        }
        HttpdHeaders header = request.getHeader();
        return header.getHeader(GET_COOKIE);
    }
}

