/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.util.FileUtil;

public class CometTriggerScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected long updateTime = -1L;
    protected ExecutionScriptImpl executionScript = null;
    private SrcScript srcScript = null;
    private int packageId = -1;

    private CometTriggerScript() {
    }

    public CometTriggerScript(String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new HttpdStateException(500, "\u30b3\u30e1\u30c3\u30c8\u30c8\u30ea\u30ac\u30fc\u306e\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + "application/" + (path.startsWith("/") ? path.substring(1, path.length()) : path)))) {
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30b3\u30e1\u30c3\u30c8\u30c8\u30ea\u30ac\u30fc\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.path = path;
        this.fileName = fileName;
    }

    public synchronized ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30b3\u30e1\u30c3\u30c8\u30c8\u30ea\u30ac\u30fc\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript == null || this.updateTime != FileUtil.getLastTime((String)this.fileName) || this.packageId != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return this.executionScript;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized String getScriptName() {
        return this.fileName;
    }

    public int getScriptType() {
        return 31;
    }

    public synchronized SrcScript getSrcScript() {
        return this.srcScript;
    }

    public synchronized boolean isScript() {
        return this.executionScript != null;
    }

    public static final String getTriggerName(String path) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            return null;
        }
        if (path.endsWith(".ms")) {
            path = path.substring(0, path.length() - ".ms".length());
        }
        path = path.endsWith("JComet") ? path.substring(0, path.length() - "JComet".length()) : path.substring(0, path.length() - "Comet".length());
        path = String.valueOf(path) + "Trigger.ms";
        String currentDirectory = ScriptDef.trimCurrentDirectory(FileUtil.getFullPath((String)"."));
        String fileName = currentDirectory + "application/" + (path.startsWith("/") ? path.substring(1, path.length()) : path);
        if (!FileUtil.isFileExists((String)fileName)) {
            return null;
        }
        return path;
    }

    protected void readScript() throws Exception {
        String script = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
        if (script == null) {
            this.executionScript = null;
            return;
        }
        StringBuilder buf = new StringBuilder();
        this.packageId = JsDef.pushDefaultPackage(buf);
        buf.append("scriptMemorys = Bindings() ;\nvar params = jmap(_$script$query); var sessions = sessionMap();\n");
        buf.append(script);
        script = buf.toString();
        buf = null;
        this.srcScript = new SrcScript(script);
        this.executionScript = new ExecutionScriptImpl("js", this.getScriptType(), this.getPath(), script);
        script = null;
        this.updateTime = FileUtil.getLastTime((String)this.fileName);
    }
}

