/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import org.maachang.util.ConvertParam;

public class HttpdSession {
    public static final String SESSION_NAME = "maachang-session";
    private String sessionId = null;
    private HashMap<String, String> elements = null;
    private Date createDate = null;
    private Date updateDate = null;

    private HttpdSession() {
    }

    public HttpdSession(String sessionId) {
        this.sessionId = sessionId;
        this.createDate = new Date();
        this.updateDate = new Date();
    }

    public synchronized void setElement(String key, String value) {
        if (key == null || key.length() <= 0 || value == null || value.length() <= 0) {
            return;
        }
        if (this.elements == null) {
            this.elements = new HashMap();
        }
        this.elements.put(key, value);
    }

    public synchronized void removeElement(String key) {
        if (key == null && key.length() <= 0) {
            return;
        }
        this.updateDate = new Date();
        if (this.elements != null) {
            this.elements.remove(key);
        }
    }

    public synchronized String getElement(String key) {
        if (key == null && key.length() <= 0) {
            return null;
        }
        this.updateDate = new Date();
        if (this.elements != null) {
            return this.elements.get(key);
        }
        return null;
    }

    public synchronized int size() {
        if (this.elements != null) {
            return this.elements.size();
        }
        return 0;
    }

    public synchronized String getSessionId() {
        return this.sessionId;
    }

    public synchronized Date getCreateDate() {
        return this.createDate;
    }

    public synchronized Date getUpdateDate() {
        return this.updateDate;
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" sessionId:").append(this.sessionId);
        buf.append(" createTime:").append(this.createDate);
        buf.append(" updateTime:").append(this.createDate);
        buf.append(" elements: {");
        if (this.elements.size() > 0) {
            Object[] key = this.elements.keySet().toArray();
            int len = key.length;
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(" ,");
                }
                buf.append(" key:").append(key[i]);
                buf.append(" value:").append(this.elements.get((String)key[i]));
                ++i;
            }
        }
        buf.append(" }");
        return buf.toString();
    }

    protected static final HttpdSession loadSession(InputStream in) throws Exception {
        byte[] bin = new byte[4];
        int len = in.read(bin);
        if (len == -1) {
            return null;
        }
        if (len != 4) {
            throw new IOException("Session\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        len = ConvertParam.convertInt((int)0, (byte[])bin);
        if (len < 0) {
            throw new IOException("Session\u30ed\u30fc\u30c9\u4e2d\u306b\u4e0d\u6b63\u306a\u30b7\u30fc\u30b1\u30f3\u30b9ID[" + len + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
        }
        if (in.read(bin) != 4) {
            throw new IOException("Session\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        len = ConvertParam.convertInt((int)0, (byte[])bin);
        if (len <= 0) {
            throw new IOException("Session\u30ed\u30fc\u30c9\u4e2d\u306b\u4e0d\u6b63\u306a\u30bb\u30c3\u30b7\u30e7\u30f3ID\u9577\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
        }
        bin = new byte[len];
        if (in.read(bin) != len) {
            throw new IOException("Session\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        HttpdSession session = new HttpdSession();
        session.sessionId = new String(bin, "UTF8");
        bin = new byte[8];
        if (in.read(bin) != 8) {
            throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        session.createDate = new Date(ConvertParam.convertLong((int)0, (byte[])bin));
        if (in.read(bin) != 8) {
            throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        session.updateDate = new Date(System.currentTimeMillis() - ConvertParam.convertLong((int)0, (byte[])bin));
        bin = null;
        while ((len = in.read(bin = new byte[4])) != -1) {
            if (len != 4) {
                throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            len = ConvertParam.convertInt((int)0, (byte[])bin);
            if (len == 0) break;
            if (len <= 0) {
                throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u4e2d\u306b\u4e0d\u6b63\u306a\u30ad\u30fc\u540d\u9577\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            bin = new byte[len];
            if (in.read(bin) != len) {
                throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            String key = new String(bin, "UTF8");
            bin = new byte[4];
            if (in.read(bin) != 4) {
                throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            len = ConvertParam.convertInt((int)0, (byte[])bin);
            if (len <= 0) {
                throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u4e2d\u306b\u4e0d\u6b63\u306a\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u9577\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            bin = new byte[len];
            if (in.read(bin) != len) {
                throw new IOException("Session[" + session.sessionId + "]\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            String val = HttpdSession.getObject(bin);
            bin = null;
            if (session.elements == null) {
                session.elements = new HashMap();
            }
            session.elements.put(key, val);
        }
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void saveSessoin(int id, OutputStream out) throws Exception {
        if (this.elements != null) {
            out.write(new byte[4]);
            out.write(ConvertParam.convertInt((int)id));
            byte[] bin = this.sessionId.getBytes("UTF8");
            out.write(ConvertParam.convertInt((int)bin.length));
            out.write(bin);
            out.write(ConvertParam.convertLong((long)this.createDate.getTime()));
            out.write(ConvertParam.convertLong((long)(System.currentTimeMillis() - this.updateDate.getTime())));
            bin = null;
            int len = this.elements.size();
            if (len > 0) {
                Object[] names = this.elements.keySet().toArray();
                int i = 0;
                while (i < len) {
                    try {
                        try {
                            byte[] v;
                            String name = (String)names[i];
                            if (name != null && name.length() > 0 && (v = HttpdSession.convertBinary(this.elements.get(name))) != null && v.length > 0) {
                                bin = name.getBytes("UTF8");
                                out.write(ConvertParam.convertInt((int)bin.length));
                                out.write(bin);
                                bin = null;
                                out.write(ConvertParam.convertInt((int)v.length));
                                out.write(v);
                                v = null;
                            }
                        }
                        finally {
                            bin = null;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
        }
    }

    private static final byte[] convertBinary(String value) {
        if (value == null || value.length() <= 0) {
            return null;
        }
        byte[] ret = null;
        try {
            ret = value.getBytes("UTF8");
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    private static final String getObject(byte[] bin) {
        if (bin == null || bin.length <= 0) {
            return null;
        }
        String ret = null;
        try {
            ret = new String(bin, "UTF8");
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }
}

