/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.httpd.engine.session.SessionMonitorThread;
import org.maachang.util.FileUtil;
import org.maachang.util.RandomUtil;

public class HttpdSessionManager {
    public static final int SESSION_ID_LENGTH = 48;
    private static final long DEF_DELETE_TIME = 1800000L;
    private HashMap<String, HttpdSession> sessions = null;
    private long deleteSessionTime = -1L;
    private SessionMonitorThread SessionMonitorThread = null;

    public HttpdSessionManager() {
        this(1800000L);
    }

    public HttpdSessionManager(long deleteSessionTime) {
        if (deleteSessionTime <= 0L) {
            deleteSessionTime = 1800000L;
        }
        this.deleteSessionTime = deleteSessionTime;
        this.sessions = new HashMap();
        this.SessionMonitorThread = new SessionMonitorThread(this);
    }

    protected void finalize() {
        this.destroy();
    }

    public void destroy() {
        this.sessions = null;
        this.deleteSessionTime = -1L;
        if (this.SessionMonitorThread != null) {
            this.SessionMonitorThread.setEndFlag();
        }
        this.SessionMonitorThread = null;
    }

    public synchronized HttpdSession getNewSession() {
        String sessionId = null;
        while (this.sessions.get(sessionId = RandomUtil.randomString((int)48, (boolean)true, (boolean)true, (boolean)true)) != null) {
            sessionId = null;
        }
        HttpdSession session = new HttpdSession(sessionId);
        this.sessions.put(sessionId, session);
        return session;
    }

    public synchronized HttpdSession getSession(String id) {
        if (this.sessions.get(id) == null) {
            HttpdSession session = new HttpdSession(id);
            this.sessions.put(id, session);
            return session;
        }
        return this.sessions.get(id);
    }

    public synchronized void removeSession(String id) {
        this.sessions.remove(id);
    }

    public synchronized long getDeleteTime() {
        return this.deleteSessionTime;
    }

    public synchronized int size() {
        return this.sessions.size();
    }

    protected synchronized String[] getSessionIds() {
        if (this.sessions != null && this.sessions.size() > 0) {
            int len = this.sessions.size();
            Object[] objs = this.sessions.keySet().toArray();
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)objs[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void loadSession(String name) throws Exception {
        BufferedInputStream bi = null;
        try {
            if (!FileUtil.isFileExists((String)name)) return;
            if (!FileUtil.isRead((String)name)) {
                return;
            }
            this.SessionMonitorThread.setStopFlag(true);
            HttpdSessionManager.sleep();
            bi = new BufferedInputStream(new FileInputStream(name));
            if (bi.read() == -1) return;
            if (bi.read() == -1) return;
            if (bi.read() == -1) return;
            if (bi.read() == -1) {
                return;
            }
            while (true) {
                HttpdSession session;
                if ((session = HttpdSession.loadSession(bi)) == null) {
                    bi.close();
                    bi = null;
                    return;
                }
                if (this.sessions == null) {
                    this.sessions = new HashMap();
                }
                this.sessions.put(session.getSessionId(), session);
            }
        }
        finally {
            this.SessionMonitorThread.setStopFlag(false);
            if (bi != null) {
                try {
                    bi.close();
                }
                catch (Exception exception) {}
            }
            bi = null;
        }
    }

    public synchronized void saveSession(String name) throws Exception {
        this.saveSession(false, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void saveSession(boolean mode, String name) throws Exception {
        FilterOutputStream bo = null;
        try {
            if (FileUtil.isFileExists((String)name) && !FileUtil.isWrite((String)name)) {
                throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u3001\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093");
            }
            if (mode) {
                this.SessionMonitorThread.setStopFlag(true);
            } else {
                this.SessionMonitorThread.setEndFlag();
            }
            HttpdSessionManager.sleep();
            bo = new BufferedOutputStream(new FileOutputStream(name));
            String[] names = this.getSessionIds();
            if (names == null || names.length <= 0) {
                bo.write(new byte[4]);
                ((BufferedOutputStream)bo).flush();
                bo.close();
                bo = null;
                return;
            }
            int len = names.length;
            int i = 0;
            while (i < len) {
                HttpdSession value = this.sessions.get(names[i]);
                value.saveSessoin(i, bo);
                ++i;
            }
            ((BufferedOutputStream)bo).flush();
            bo.close();
            bo = null;
            return;
        }
        finally {
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (Exception exception) {}
            }
            if (mode) {
                this.SessionMonitorThread.setStopFlag(false);
            }
        }
    }

    private static final void sleep() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

