/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpSocket;
import org.maachang.comet.net.HttpServer;
import org.maachang.comet.net.HttpSocketManager;

public class HttpAcceptThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(HttpAcceptThread.class);
    private HttpServer server = null;
    private HttpSocketManager manager = null;
    private volatile boolean stopFlag = true;

    private HttpAcceptThread() {
    }

    public HttpAcceptThread(HttpServer server, HttpSocketManager manager) throws Exception {
        this.server = server;
        this.manager = manager;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public HttpSocketManager getVtSocketManager() {
        return this.manager;
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            HttpSocket s = null;
            try {
                s = this.server.accept();
                if (s == null) continue;
                this.manager.append(s);
            }
            catch (InterruptedException ite) {
                endFlag = true;
            }
            catch (NullPointerException ite) {
            }
            catch (OutOfMemoryError mem) {
                LOG.error((Object)"## out-of-memory-error", (Throwable)mem);
            }
            catch (Exception e) {
                LOG.error((Object)"## error", (Throwable)e);
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.server = null;
        this.manager = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

