/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.OutputStream;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpSocket;
import org.maachang.comet.net.HttpOutputStream;
import org.maachang.comet.net.HttpSocketManager;
import org.maachang.comet.net.KeepAliveTimerManager;

public class NetHttpConnectionInfoImpl
implements HttpConnectionInfo {
    private HttpSocketManager manager = null;
    private KeepAliveTimerManager timerMan = null;
    private HttpSocket socket = null;
    private HttpOutputStream outputStream = null;
    private long timeout = -1L;
    private int count = -1;

    private NetHttpConnectionInfoImpl() {
    }

    protected NetHttpConnectionInfoImpl(HttpSocket socket, HttpSocketManager manager, KeepAliveTimerManager timerMan) {
        this.manager = manager;
        this.timerMan = timerMan;
        this.socket = socket;
        this.timeout = timerMan.getTimeout();
        this.count = timerMan.getKeepAliveCount();
        this.outputStream = null;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        this.cancel();
        this.manager = null;
        this.timerMan = null;
        this.socket = null;
        this.outputStream = null;
        this.timeout = -1L;
        this.count = -1;
    }

    public synchronized void cancel() {
        if (this.outputStream != null) {
            try {
                this.outputStream.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputStream = null;
        }
    }

    public synchronized HttpSocket getSocket() {
        return this.socket;
    }

    public synchronized void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void setCount(int count) {
        this.count = count;
    }

    public synchronized long getTimeout() {
        return this.timeout;
    }

    public synchronized int getCount() {
        return this.count;
    }

    public synchronized void update() throws Exception {
        this.socket.update();
        this.cancel();
        --this.count;
    }

    public synchronized boolean recyclingConnection() {
        if (this.timerMan != null && this.manager != null) {
            this.cancel();
            this.timerMan.append(this);
            this.manager.append(this.socket);
            return true;
        }
        return false;
    }

    public synchronized void resetTimer() {
        if (this.timerMan != null && this.manager != null) {
            this.timeout = this.timerMan.getTimeout();
        }
    }

    public synchronized long getTimer() {
        return this.socket.time();
    }

    public synchronized OutputStream getOutputStream() throws Exception {
        if (this.outputStream == null) {
            this.outputStream = new HttpOutputStream(this.socket.outputStream());
        }
        return this.outputStream;
    }

    public synchronized void setCloseFlag(boolean mode) {
        this.socket.setCloseFlag(mode);
    }

    public synchronized boolean isCloseFlag() {
        return this.socket.isCloseFlag();
    }

    public synchronized boolean isOutputStream() {
        return this.outputStream != null;
    }

    public synchronized boolean isUse() {
        return this.socket != null && !this.socket.isClosed();
    }
}

