/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.util.ASCIIUtility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResponseInputStream {
    private static final int minIncrement = 256;
    private static final int maxIncrement = 262144;
    private byte[] buffer = null;
    private int sz = 0;
    private int idx = 0;
    private BufferedInputStream bin;

    public ResponseInputStream(InputStream inputStream) {
        this.bin = new BufferedInputStream(inputStream, 2048);
    }

    public ByteArray readResponse() throws IOException {
        this.buffer = new byte[128];
        this.idx = 0;
        this.sz = 128;
        this.read0();
        return new ByteArray(this.buffer, 0, this.idx);
    }

    private void read0() throws IOException {
        int n = 0;
        boolean bl = false;
        while (!bl && (n = this.bin.read()) != -1) {
            switch (n) {
                case 10: {
                    if (this.idx <= 0 || this.buffer[this.idx - 1] != 13) break;
                    bl = true;
                }
            }
            if (this.idx >= this.sz) {
                if (this.sz < 262144) {
                    this.growBuffer(this.sz);
                } else {
                    this.growBuffer(262144);
                }
            }
            this.buffer[this.idx++] = (byte)n;
        }
        if (n == -1) {
            throw new IOException();
        }
        if (this.idx >= 5 && this.buffer[this.idx - 3] == 125) {
            int n2 = this.idx - 4;
            while (n2 >= 0) {
                if (this.buffer[n2] == 123) break;
                --n2;
            }
            if (n2 < 0) {
                return;
            }
            int n3 = 0;
            try {
                n3 = ASCIIUtility.parseInt((byte[])this.buffer, (int)(n2 + 1), (int)(this.idx - 3));
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n3 > 0) {
                int n4 = this.sz - this.idx;
                if (n3 > n4) {
                    this.growBuffer(256 > n3 - n4 ? 256 : n3 - n4);
                }
                while (n3 > 0) {
                    int n5 = this.bin.read(this.buffer, this.idx, n3);
                    n3 -= n5;
                    this.idx += n5;
                }
            }
            this.read0();
        }
    }

    private void growBuffer(int n) {
        byte[] byArray = new byte[this.sz + n];
        if (this.buffer != null) {
            System.arraycopy(this.buffer, 0, byArray, 0, this.idx);
        }
        this.buffer = byArray;
        this.sz += n;
    }
}

