/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import java.util.HashMap;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;

public class DaoSession {
    private HashMap<String, MetaColumn> tables = null;
    private Record record = null;

    private DaoSession() {
    }

    public DaoSession(Record record) throws MaachangDaoException {
        if (record == null) {
            throw new MaachangDaoException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.record = record;
    }

    public DaoSession(Record record, String name, MetaColumn meta) throws MaachangDaoException {
        if (record == null || name == null || meta == null || (name = name.trim()).length() <= 0) {
            throw new MaachangDaoException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.record = record;
        this.tables = new HashMap();
        this.tables.put(name, meta);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.record != null) {
            try {
                this.record.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.record.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.record = null;
        this.tables = null;
    }

    public void clear() {
        this.record = null;
        this.tables = null;
    }

    public Record getRecord() {
        return this.record;
    }

    public synchronized MetaColumn getMeta(String name) throws MaachangDaoException {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new MaachangDaoException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            MetaColumn meta = null;
            if (this.tables == null || (meta = this.tables.get(name)) == null) {
                if (this.tables == null) {
                    this.tables = new HashMap();
                }
                if ((meta = this.record.getMetaColumn(DbUtil.convertJavaNameByDBName(name))) == null) {
                    throw new MaachangDaoException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                this.tables.put(name, meta);
            }
            return meta;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }
}

