// 将棋操作用コントローラ.
//

// チャット履歴表示最大件数.
var MAX_CHAT_LENGTH = 512 ;

// IDが存在しない場合.
if( isNull( params['id'] ) == true ) {
    // topにリダイレクト.
    redirect( "/top" ) ;
}

// 対局情報を取得.
var fight = ShogiFight.first_by_id( params['id'] ) ;

// 対局情報が存在しない場合は、TOPに遷移.
if( isNull( fight ) || fight.length <= 0 ) {
    redirect( "/top" ) ;
}
fight = fight[0] ;
// 対局情報が、現在対局中でない場合は、TOPに遷移.
if( isNull( fight.fightUser ) || isNull( fight.editUser ) || fight.exitFlag == true ) {
    redirect( "/top" ) ;
}

// 対局内容をセット.
params['fight'] = fight ;
params['srcUserName'] = ShogiUser.find_by_id( fight.editUser )[ 0 ].name ;
params['destUserName'] = ShogiUser.find_by_id( fight.fightUser )[ 0 ].name ;

// チャット履歴をセット.
var chat = ShogiChat.limit( 0,MAX_CHAT_LENGTH,"$fight_id=?",fight.id,"id desc" ) ;
// チャット履歴が存在する.
if( isNull( chat ) == false && chat.length > 0 ) {
    var len = chat.length ;
    var msg = ""
    for( var i = 0 ; i < len ; i ++ ) {
        if( i != 0 ) {
            msg += "<BR>" ;
        }
        msg += ""+chat[i].userName+"&nbsp;[" + formatDateByString( chat[i].createTime,true ) + "]：&nbsp;" + convertViewHtml( chat[i].message ) ;
    }
    params['view_chat'] = msg ;
    params['chat_last_id'] = chat[0].id ;
}
// チャット履歴が存在しない場合は、開始情報を登録.
else {
    var bean = ShogiChat.bean() ;
    bean.fightId = fight.id ;
    bean.userName = "将棋管理者" ;
    bean.message = "開始します." ;
    ShogiChat.save( bean ) ;
    params['view_chat'] = bean.userName + "&nbsp;[" + formatDateByString( new Date() ) + "]:開始します." ;
    params['chat_last_id'] = ""+bean.id ;
}

params['session_user'] = sessions['user'] ;
//if( useString( params['login_user_id'] ) == true ) {
//    params['session_user'] = ShogiUser.first_by_id( params['login_user_id'] )[0] ;
//}
//else {
//    params['session_user'] = sessions['user'] ;
//}

